<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Kuis Edukasi Gizi - TLC Bites</title>
<style>
:root {
  --green: #2ea153;
  --yellow: #f5c23a;
}
* {
  box-sizing: border-box;
  font-family: "Poppins", sans-serif;
}
body {
  background: linear-gradient(180deg, #ffffff 60%, #fafff6 100%);
  margin: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 100vh;
}
.quiz-container {
  background: #fff;
  border-radius: 18px;
  width: 92%;
  max-width: 420px;
  padding: 24px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.08);
  position: relative;
  overflow: hidden;
  transition: all .4s ease;
}
.progress {
  height: 8px;
  background: #eee;
  border-radius: 10px;
  overflow: hidden;
  margin-bottom: 20px;
}
.progress-bar {
  height: 100%;
  width: 0%;
  background: linear-gradient(90deg, var(--green), var(--yellow));
  transition: width 0.3s ease;
}
h2 {
  text-align: center;
  color: #333;
  margin: 0 0 10px;
  font-size: 20px;
}
h4.category {
  text-align: center;
  color: var(--green);
  font-size: 14px;
  margin: 0 0 15px;
  font-weight: 600;
}
.question {
  font-size: 16px;
  margin-bottom: 15px;
  color: #222;
  font-weight: 500;
}
.options {
  display: flex;
  flex-direction: column;
  gap: 10px;
}
.option {
  border: 1px solid #ccc;
  border-radius: 12px;
  padding: 12px;
  text-align: left;
  cursor: pointer;
  transition: 0.25s;
}
.option:hover { background: #f9fff9; border-color: var(--green); }
.option.selected {
  background: #e8ffe8;
  border-color: var(--green);
}
.option.correct { background: #e8ffe8; border-color: var(--green); color: #1e7e34; font-weight:600; }
.option.wrong { background: #ffeaea; border-color: #f33; color: #a00; font-weight:600; }
.next-btn {
  margin-top: 20px;
  background: var(--green);
  color: #fff;
  border: none;
  border-radius: 10px;
  padding: 12px;
  width: 100%;
  font-size: 15px;
  font-weight: 600;
  cursor: pointer;
  display: none;
}
.result-screen {
  display: none;
  text-align: center;
}
.result-screen h3 {
  font-size: 22px;
  color: #111;
}
.score {
  font-size: 36px;
  color: var(--green);
  margin: 10px 0;
}
.emoji {
  font-size: 42px;
  margin-top: 10px;
}
.decor {
  position: absolute;
  top: -20px;
  right: -20px;
  width: 100px;
  height: 100px;
  background: radial-gradient(var(--yellow), transparent 70%);
  border-radius: 50%;
  opacity: 0.2;
}
#welcome {
  text-align: center;
  display: block;
  animation: fadeIn .6s ease;
}
#welcome img {
  width: 160px;
  margin: 20px auto 10px;
  display: block;
}
#welcome h1 {
  font-size: 22px;
  color: var(--green);
  margin-bottom: 6px;
}
#welcome p {
  font-size: 14px;
  color: #555;
  margin: 0 0 20px;
}
.start-btn {
  background: linear-gradient(90deg,var(--green),var(--yellow));
  border:none;
  color:#fff;
  font-size:16px;
  padding:12px 20px;
  border-radius:12px;
  cursor:pointer;
  font-weight:600;
  width:100%;
}
@keyframes fadeIn{from{opacity:0;transform:translateY(10px);}to{opacity:1;transform:translateY(0);}}
</style>
</head>
<body>

<div class="quiz-container">
  <div class="decor"></div>

  <!-- 🟢 HALAMAN WELCOME -->
  <div id="welcome">
    <img src="https://cdn-icons-png.flaticon.com/512/706/706164.png" alt="avatar">
    <h1>Selamat Datang di Kuis Gizi! 🥗</h1>
    <p>Yuk uji pengetahuanmu tentang hiperkolesterolemia, faktor risiko, dan gaya hidup sehat bersama TLC Bites 💪</p>
    <button class="start-btn" onclick="startQuiz()">Mulai Kuis 🚀</button>
  </div>

  <!-- 🟢 HALAMAN KUIS -->
  <div id="quizBox" style="display:none;">
    <div class="progress"><div class="progress-bar" id="progressBar"></div></div>
    <h2>Kuis Edukasi Gizi</h2>
    <h4 id="category" class="category"></h4>
    <div id="questionText" class="question"></div>
    <div id="options" class="options"></div>
    <button class="next-btn" id="nextBtn">Kunci Jawaban ➡️</button>
  </div>

  <!-- 🟢 HALAMAN HASIL -->
  <div class="result-screen" id="resultBox">
    <h3>Hasil Akhirmu 🎯</h3>
    <div class="score" id="finalScore"></div>
    <p id="finalText"></p>
    <div class="emoji" id="emojiResult"></div>
    <button class="next-btn" onclick="location.reload()">Ulangi Kuis 🔁</button>
  </div>
</div>

<script>
const quizData = [
  {cat:"A. Pengetahuan tentang Hiperkolesterolemia", q:"Kadar kolesterol total yang dianggap tinggi pada orang dewasa adalah …", options:["≥ 120 mg/dL","≥ 150 mg/dL","≥ 200 mg/dL","≥ 250 mg/dL"], answer:2},
  {cat:"A. Pengetahuan tentang Hiperkolesterolemia", q:"Hiperkolesterolemia hanya bisa dideteksi dengan …", options:["Mengukur tekanan darah","Pemeriksaan laboratorium darah","Berat badan","Indeks Massa Tubuh"], answer:1},
  {cat:"B. Faktor Risiko dan Pemicu", q:"Berikut ini yang bukan faktor risiko hiperkolesterolemia adalah …", options:["Konsumsi fast food berlebihan","Aktivitas fisik teratur","Asupan lemak jenuh","Kualitas tidur buruk"], answer:1},
  {cat:"B. Faktor Risiko dan Pemicu", q:"Konsumsi minuman manis sebaiknya dibatasi maksimal …", options:["100 ml atau 1 sdm gula","150 ml atau 2 sdm gula","236 ml atau 4 sdm gula","500 ml atau 8 sdm gula"], answer:2},
  {cat:"C. Faktor Protektif", q:"Rekomendasi konsumsi buah & sayur menurut pedoman adalah …", options:["1 porsi buah dan 1 porsi sayur per hari","2–3 porsi buah dan 3–4 porsi sayur per hari","Hanya sayur saja minimal 3 porsi","Buah dan sayur tidak wajib setiap hari"], answer:1},
  {cat:"C. Faktor Protektif", q:"Aktivitas fisik minimal untuk usia 18–40 tahun menurut TLC adalah …", options:["30 menit setiap hari","150 menit per minggu","60 menit per minggu","90 menit per bulan"], answer:1},
  {cat:"D. Gaya Hidup dan Diet", q:"Salah satu langkah diet TLC (Mediterania) adalah …", options:["Mengonsumsi gorengan setiap hari","Mengganti camilan manis dengan buah/kacang","Menggunakan santan kental untuk memasak","Menghindari semua jenis minyak"], answer:1},
  {cat:"D. Gaya Hidup dan Diet", q:"Contoh minyak sehat yang dianjurkan adalah …", options:["Minyak kelapa sawit","Minyak zaitun","Mentega","Lemak babi"], answer:1},
  {cat:"E. Aplikasi Sehari-hari", q:"Mengapa kualitas tidur yang buruk dapat meningkatkan kolesterol?", options:["Karena meningkatkan kadar ghrelin dan menurunkan leptin","Karena mengurangi produksi hormon insulin","Karena menurunkan energi basal","Karena meningkatkan kadar vitamin D"], answer:0},
  {cat:"E. Aplikasi Sehari-hari", q:"Fast food umumnya mengandung …", options:["Rendah kalori, tinggi serat","Tinggi lemak, tinggi garam, rendah serat","Rendah lemak, tinggi protein","Tinggi vitamin dan mineral"], answer:1}
];

let current = 0, score = 0, selected = null, locked = false;
const qText = document.getElementById("questionText");
const category = document.getElementById("category");
const opts = document.getElementById("options");
const nextBtn = document.getElementById("nextBtn");
const progress = document.getElementById("progressBar");

function startQuiz(){
  document.getElementById("welcome").style.display="none";
  document.getElementById("quizBox").style.display="block";
  loadQuestion();
}

function loadQuestion(){
  const q = quizData[current];
  qText.innerText = q.q;
  category.innerText = q.cat;
  opts.innerHTML = "";
  locked = false; selected = null;
  q.options.forEach((opt,i)=>{
    const div = document.createElement("div");
    div.classList.add("option");
    div.innerText = opt;
    div.onclick = ()=>selectOption(i,div);
    opts.appendChild(div);
  });
  progress.style.width = (current/quizData.length*100)+"%";
  nextBtn.innerText = "Kunci Jawaban ➡️";
  nextBtn.style.display = "none";
}

function selectOption(index, el){
  if(locked) return;
  document.querySelectorAll(".option").forEach(o=>o.classList.remove("selected"));
  el.classList.add("selected");
  selected = index;
  nextBtn.style.display="block";
}

nextBtn.addEventListener("click", ()=>{
  if(locked) {
    current++;
    if(current<quizData.length){loadQuestion();}
    else showResult();
  } else {
    if(selected===null) {alert("Pilih jawaban dulu ya 😺");return;}
    checkAnswer();
  }
});

function checkAnswer(){
  const q = quizData[current];
  const allOpts = document.querySelectorAll(".option");
  allOpts.forEach((opt,i)=>{
    if(i===q.answer) opt.classList.add("correct");
    if(i===selected && i!==q.answer) opt.classList.add("wrong");
    opt.style.pointerEvents="none";
  });
  if(selected===q.answer) score++;
  locked = true;
  nextBtn.innerText = (current===quizData.length-1) ? "Lihat Hasil ✅" : "Lanjut ➡️";
}

function showResult(){
  document.getElementById("quizBox").style.display="none";
  const resultBox=document.getElementById("resultBox");
  resultBox.style.display="block";
  const percentage = Math.round(score/quizData.length*100);
  document.getElementById("finalScore").innerText = `${percentage}%`;
  let text="", emoji="";
  if(percentage>=80){text="Excellent! Kamu paham sekali 💚";emoji="😸";}
  else if(percentage>=60){text="Good! Tingkatkan lagi 💪";emoji="🙂";}
  else{text="Perlu belajar lagi tentang gizi seimbang 🥦";emoji="😿";}
  document.getElementById("finalText").innerText = text;
  document.getElementById("emojiResult").innerText = emoji;
  progress.style.width = "100%";
}
</script>
</body>
</html>
