<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>TLC Bites — Asesmen Kualitas Diet</title>
<style>
  :root{
    --accent-green: #2ea153;
    --accent-yellow: #f5c23a;
    --bg: #ffffff;
    --muted:#f3faf3;
    --text:#1f2937;
    --muted-text:#6b7280;
    --danger:#d64545;
  }
  html,body{height:100%;margin:0;font-family:Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;}
  body{background:linear-gradient(180deg,#fff 60%, #fbfff5 100%);display:flex;align-items:center;justify-content:center;padding:16px;}
  /* soft decor */
  .decor {position:fixed;border-radius:50%;pointer-events:none;z-index:0;opacity:0.10}
  .decor.left{width:220px;height:220px;left:-80px;top:-80px;background:var(--accent-green)}
  .decor.right{width:180px;height:180px;right:-70px;bottom:-70px;background:var(--accent-yellow)}
  /* card */
  .wrap{width:100%;max-width:420px;z-index:1}
  .card{background:var(--bg);border-radius:14px;box-shadow:0 10px 30px rgba(0,0,0,0.08);padding:16px;box-sizing:border-box;}
  /* progress */
  .progress{height:8px;background:#eee;border-radius:6px;overflow:hidden;margin-bottom:8px}
  .progressBar{height:100%;background:var(--accent-green);width:0%;transition:width .2s linear}
  .stepLabel{font-size:12px;color:var(--muted-text);text-align:center;margin-bottom:12px}
  /* header */
  .header{display:flex;align-items:center;gap:12px;margin-bottom:6px}
  .logo{width:46px;height:46px;border-radius:10px;background:linear-gradient(135deg,var(--accent-green),var(--accent-yellow));display:flex;align-items:center;justify-content:center;color:#fff;font-weight:800}
  .title{font-size:16px;font-weight:700;color:var(--text)}
  .subtitle{font-size:13px;color:var(--muted-text);margin-top:4px}
  /* avatar */
  .avatar{width:100px;height:100px;display:block;margin:8px auto;border-radius:12px;object-fit:contain;background:#fff}
  /* question area */
  .qtitle{font-size:18px;color:var(--text);text-align:center;margin:8px 0}
  .qdesc{font-size:13px;color:var(--muted-text);text-align:center;margin-bottom:12px}
  .choices{display:flex;gap:10px;justify-content:center;margin-top:8px}
  .choice{flex:1;padding:12px;border-radius:10px;border:1px solid #eee;background:#fcfffb;color:var(--text);font-weight:700;text-align:center;cursor:pointer}
  .choice.selected{border-color:var(--accent-green);box-shadow:0 6px 18px rgba(46,161,83,0.12);background:linear-gradient(180deg,#fff,#f0fff4)}
  /* controls */
  .controls{display:flex;gap:10px;margin-top:16px}
  .btn{flex:1;padding:12px;border-radius:10px;border:none;background:var(--accent-green);color:#fff;font-weight:700;cursor:pointer}
  .btn.light{background:#fff;color:var(--accent-green);border:1px solid #e6f3e9}
  .btn:active{transform:translateY(1px)}
  /* summary */
  .summaryWrap {
    max-height: 260px;   /* agar list bisa discroll */
    overflow-y: auto;
    margin-top: 10px;
    padding-right: 6px;
  }
  .summaryItem{padding:12px;border-radius:10px;background:#fbfbfb;margin-bottom:8px;display:flex;justify-content:space-between;align-items:center}
  .summaryItem strong{display:block}
  .resultBig{font-size:20px;font-weight:800;text-align:center;margin:10px 0}
  .resultNote{font-size:14px;color:var(--muted-text);text-align:center;margin-bottom:10px}
  .badge{padding:6px 10px;border-radius:999px;color:#fff;font-weight:800}
  .badge.good{background:var(--accent-green)}
  .badge.mid{background:var(--accent-yellow);color:#000}
  .badge.bad{background:var(--danger)}
  @media (max-width:420px){
    .card{padding:14px;border-radius:12px}
    .qtitle{font-size:16px}
  }
</style>
</head>
<body>
  <div class="decor left"></div>
  <div class="decor right"></div>

  <div class="wrap">
    <div class="card" role="application" aria-label="Asesmen Kualitas Diet">

      <!-- Progress -->
      <div class="progress"><div id="progressBar" class="progressBar"></div></div>
      <div class="stepLabel" id="stepLabel">1 / 17</div>

      <!-- Header -->
      <div class="header">
        <div class="logo">TLC</div>
        <div style="flex:1">
          <div class="title">Entry: Kualitas Diet</div>
          <div class="subtitle">Jawab pertanyaan singkat tentang asupan harian/mingguanmu</div>
        </div>
      </div>

      <!-- Avatar -->
      <img id="avatar" class="avatar" src="cat-normal.gif" alt="avatar">

      <!-- Question / Summary Area -->
      <div id="contentArea"></div>

      <!-- Controls -->
      <div class="controls">
        <button id="backBtn" class="btn light" onclick="prevPage()" disabled>Back</button>
        <button id="nextBtn" class="btn" onclick="nextPage()">Next</button>
      </div>

    </div>
  </div>

<script>
const questions = [
  {id:1, text:"Apakah kamu mengonsumsi buah setiap hari?", ruleType: 'pos'},
  {id:2, text:"Apakah kamu mengonsumsi buah sebanyak 2 porsi setiap hari?", ruleType: 'pos'},
  {id:3, text:"Apakah kamu mengonsumsi sayur setiap hari?", ruleType: 'pos'},
  {id:4, text:"Apakah kamu mengonsumsi sayur lebih dari sekali sehari?", ruleType: 'pos'},
  {id:5, text:"Apakah kamu mengonsumsi ikan atau daging unggas lebih dari 2x seminggu?", ruleType: 'pos'},
  {id:6, text:"Apakah kamu mengonsumsi fast food > 1 kali seminggu?", ruleType: 'neg'},
  {id:7, text:"Apakah kamu mengonsumsi kacang-kacangan > 1 kali seminggu?", ruleType: 'pos'},
  {id:8, text:"Apakah kamu mengonsumsi serealia seperti beras dan oat (>5 kali dalam seminggu)?", ruleType: 'pos'},
  {id:9, text:"Apakah kamu mengonsumsi serealia atau kacang (termasuk tahu/tempe) untuk sarapan?", ruleType: 'pos'},
  {id:10, text:"Apakah kamu mengonsumsi kacang-kacangan (termasuk tahu/tempe) minimal 2-3 kali seminggu?", ruleType: 'pos'},
  {id:11, text:"Apakah kamu mengonsumsi minyak zaitun/minyak wijen dalam sebulan terakhir?", ruleType: 'pos'},
  {id:12, text:"Apakah kamu sering melewatkan sarapan?", ruleType: 'neg'},
  {id:13, text:"Apakah kamu memiliki persediaan susu atau olahannya (keju/yogurt) untuk sarapan?", ruleType: 'pos'},
  {id:14, text:"Apakah kamu memiliki persediaan makanan instan atau kue kering untuk sarapan?", ruleType: 'neg'},
  {id:15, text:"Apakah Anda mengkonsumsi yoghurt atau keju setiap hari?", ruleType: 'pos'},
  {id:16, text:"Apakah Anda mengonsumsi permen/cemilan manis/minuman manis lebih dari sekali setiap hari?", ruleType: 'neg'}
];

const AVATARS = {
  normal: 'cat-normal.gif',
  warning: 'cat-warning.gif',
  bad: 'cat-bad.gif'
};

let pageIndex = 0;
const answers = {};
const contentArea = document.getElementById('contentArea');
const progressBar = document.getElementById('progressBar');
const stepLabel = document.getElementById('stepLabel');
const backBtn = document.getElementById('backBtn');
const nextBtn = document.getElementById('nextBtn');
const avatarImg = document.getElementById('avatar');

renderPage();

function renderPage(){
  contentArea.innerHTML = '';
  const totalSteps = questions.length + 1;
  progressBar.style.width = ((pageIndex) / (totalSteps - 1)) * 100 + '%';
  stepLabel.innerText = `${Math.min(pageIndex+1, totalSteps)} / ${totalSteps}`;

  if(pageIndex >= questions.length){
    renderSummary();
    backBtn.disabled = false;
    nextBtn.disabled = true;
    return;
  }

  const q = questions[pageIndex];
  const qTitle = document.createElement('div');
  qTitle.className = 'qtitle';
  qTitle.innerText = `(${q.id}) ${q.text}`;

  const choices = document.createElement('div');
  choices.className = 'choices';

  const yesBtn = document.createElement('div');
  yesBtn.className = 'choice';
  yesBtn.innerText = 'Yes / Iya';
  const noBtn = document.createElement('div');
  noBtn.className = 'choice';
  noBtn.innerText = 'No / Tidak';

  if(answers[q.id] === true) yesBtn.classList.add('selected');
  if(answers[q.id] === false) noBtn.classList.add('selected');

  yesBtn.onclick = ()=>{
    answers[q.id] = true;
    yesBtn.classList.add('selected'); noBtn.classList.remove('selected');
    updateAvatarForAnswer(q, true);
    nextBtn.disabled = false;
  };
  noBtn.onclick = ()=>{
    answers[q.id] = false;
    noBtn.classList.add('selected'); yesBtn.classList.remove('selected');
    updateAvatarForAnswer(q, false);
    nextBtn.disabled = false;
  };

  choices.appendChild(yesBtn);
  choices.appendChild(noBtn);

  contentArea.appendChild(qTitle);
  contentArea.appendChild(choices);

  backBtn.disabled = pageIndex === 0;
  nextBtn.disabled = answers[q.id] === undefined;
  nextBtn.innerText = (pageIndex === questions.length - 1) ? 'Finish' : 'Next';
}

function updateAvatarForAnswer(q, answer){
  if(q.ruleType === 'pos'){
    avatarImg.src = answer ? AVATARS.normal : AVATARS.warning;
  } else {
    avatarImg.src = answer ? AVATARS.bad : AVATARS.normal;
  }
}

function nextPage(){
  if(pageIndex < questions.length) {
    if(answers[questions[pageIndex].id] === undefined){
      alert('Silakan pilih jawaban terlebih dahulu.');
      return;
    }
    pageIndex++;
    renderPage();
  }
}
function prevPage(){
  if(pageIndex > 0){
    pageIndex--;
    renderPage();
  }
}

function renderSummary(){
  contentArea.innerHTML = '';

  let total = 0;
  const details = [];
  for(const q of questions){
    const ans = answers[q.id];
    let s = 0;
    if(q.ruleType === 'pos') s = (ans===true)?1:0;
    else s = (ans===true)?-1:1;
    total += s;
    details.push({id:q.id, text:q.text, ans: ans===true?'Yes':'No', score:s});
  }

  let category = '', badgeClass='';
  if(total <= 3){ category='Kualitas diet buruk'; badgeClass='bad'; avatarImg.src=AVATARS.bad; }
  else if(total<=7){ category='Kualitas diet: butuh perbaikan'; badgeClass='mid'; avatarImg.src=AVATARS.warning; }
  else { category='Kualitas diet: optimal'; badgeClass='good'; avatarImg.src=AVATARS.normal; }

  const h = document.createElement('div');
  h.innerHTML = `
    <div class="resultBig">Skor: <strong>${total}</strong></div>
    <div style="text-align:center;margin-bottom:8px"><span class="badge ${badgeClass}">${category}</span></div>
    <div class="resultNote">Skor dihitung dari 16 pertanyaan.</div>
    <div class="summaryWrap"><div class="summary" id="summaryList"></div></div>
  `;
  contentArea.appendChild(h);

  const list = document.getElementById('summaryList');
  for(const d of details){
    const itm = document.createElement('div');
    itm.className = 'summaryItem';
    itm.innerHTML = `<div style="flex:1"><strong>${d.id}. ${d.text}</strong><div style="font-size:12px;color:${d.ans==='Yes'?'#1f7a3a':'#6b7280'}">${d.ans}</div></div><div style="font-weight:800">${d.score>0? '+'+d.score : d.score}</div>`;
    list.appendChild(itm);
  }

  const ctrl = document.createElement('div');
  ctrl.style.marginTop='12px';
  ctrl.innerHTML = `
    <div style="display:flex;gap:10px">
      <button class="btn" onclick="restart()">Ulangi</button>
      <button class="btn light" onclick="copyResult()">Salin Hasil</button>
    </div>
  `;
  contentArea.appendChild(ctrl);

  backBtn.disabled = true;
  nextBtn.disabled = true;
  stepLabel.innerText = `Selesai`;
  progressBar.style.width = '100%';
}

function restart(){
  for(const k in answers) delete answers[k];
  pageIndex=0; avatarImg.src=AVATARS.normal; renderPage();
}
function copyResult(){
  let text='Hasil Asesmen Kualitas Diet\n'; let total=0;
  for(const q of questions){
    const ans=answers[q.id]; let s=0;
    if(q.ruleType==='pos') s=(ans===true)?1:0;
    else s=(ans===true)?-1:1;
    total+=s;
    text+=`${q.id}. ${q.text} -> ${ans?'Yes':'No'} (score ${s})\n`;
  }
  text+=`TOTAL: ${total}\n`;
  navigator.clipboard?.writeText(text).then(()=>alert('Hasil disalin ke clipboard'),()=>alert('Gagal menyalin'));
}
</script>
</body>
</html>
