<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>TLC Bites — Entry Makan</title>
<style>
  :root{
    --accent-green: #2ea153;
    --accent-yellow:#f5c23a;
    --bg: #ffffff;
    --muted: #f6fbf6;
    --card: #fff;
    --text:#1f2937;
    --muted-text:#6b7280;
  }
  html,body{height:100%;margin:0;font-family:Inter,system-ui,Arial,sans-serif;background:linear-gradient(180deg,#ffffff 60%, #fbfff5 100%);}
  /* decorative soft shapes */
  .decor{position:fixed;border-radius:50%;pointer-events:none;z-index:0;opacity:0.10}
  .decor.left{width:220px;height:220px;left:-80px;top:-80px;background:var(--accent-green)}
  .decor.right{width:180px;height:180px;right:-70px;bottom:-70px;background:var(--accent-yellow)}
  .wrap{max-width:420px;margin:0 auto;padding:18px;position:relative;z-index:1;min-height:100vh;display:flex;align-items:center;justify-content:center}
  .card{width:100%;background:var(--card);border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,0.08);padding:16px;box-sizing:border-box;display:flex;flex-direction:column;align-items:stretch}
  /* progress */
  .progressRow{margin-bottom:10px}
  .progress{height:8px;background:#eee;border-radius:6px;overflow:hidden}
  .progressBar{height:100%;background:var(--accent-green);width:0%;transition:width .28s ease}
  .stepLabel{font-size:12px;color:var(--muted-text);text-align:center;margin-top:8px}
  /* header */
  .header{display:flex;align-items:center;gap:12px}
  .logo{width:48px;height:48px;border-radius:10px;background:linear-gradient(135deg,var(--accent-green),var(--accent-yellow));display:flex;align-items:center;justify-content:center;color:white;font-weight:700}
  .title{font-size:16px;font-weight:700;color:var(--text)}
  .lead{font-size:13px;color:var(--muted-text);margin-top:6px}
  /* question area */
  .qbox{margin-top:12px}
  h2.q{margin:0;font-size:18px;color:var(--text);text-align:center}
  p.sub{margin:6px 0 10px 0;color:var(--muted-text);font-size:13px;text-align:center}
  .options{display:flex;flex-direction:column;gap:10px;margin-top:6px}
  .opt{padding:12px;border-radius:10px;border:1px solid #eee;background:#fcfffb;color:var(--text);font-weight:600;font-size:14px;text-align:center;cursor:pointer}
  .opt.selected{border-color:var(--accent-green);box-shadow:0 4px 14px rgba(46,161,83,0.12);background:linear-gradient(180deg,#ffffff,#f0fff4)}
  .small{font-size:13px;color:var(--muted-text);font-weight:500}
  /* controls */
  .controls{display:flex;gap:10px;margin-top:18px}
  .btn{flex:1;padding:12px;border-radius:10px;border:none;background:var(--accent-green);color:#fff;font-weight:700;cursor:pointer}
  .btn.light{background:#fff;color:var(--accent-green);border:1px solid #e6f3e9}
  .btn:active{transform:translateY(1px)}
  /* summary */
  .summary{margin-top:12px}
  .summaryItem{padding:10px;border-radius:10px;background:#fbfbfb;margin-bottom:8px;display:flex;justify-content:space-between;align-items:center}
  .summaryItem .meta{font-size:13px;color:var(--muted-text)}
  /* responsive tweak */
  @media (max-width:420px){
    .card{padding:14px;border-radius:12px}
    h2.q{font-size:16px}
  }
</style>
</head>
<body>
  <div class="decor left"></div>
  <div class="decor right"></div>

  <div class="wrap">
    <div class="card" role="application" aria-label="Asesmen Entry Makan">

      <!-- progress -->
      <div class="progressRow">
        <div class="progress"><div id="progressBar" class="progressBar"></div></div>
        <div class="stepLabel" id="stepLabel">1 / 9</div>
      </div>

      <!-- header -->
      <div class="header">
        <div class="logo">TLC</div>
        <div style="flex:1">
          <div class="title">Entry Makan</div>
          <div class="lead">Jawab beberapa pertanyaan singkat tentang kebiasaan makanmu</div>
        </div>
      </div>

      <!-- content area (questions) -->
      <div id="pageArea" style="margin-top:10px">

        <!-- pages will be rendered here by JS -->

      </div>

      <!-- controls -->
      <div style="display:flex;gap:10px;margin-top:16px">
        <button id="backBtn" class="btn light" onclick="prevPage()" disabled>Back</button>
        <button id="nextBtn" class="btn" onclick="nextPage()">Continue</button>
      </div>

    </div>
  </div>

<script>
/* ---------- Questions as array of pages ---------- */
const pages = [
  // page 1: intro (already represented by header) - we will still have a welcome page
  {
    id: 'welcome',
    title: 'Halo Kawan 👋',
    body: 'Mari kita mulai. Jawab jujur agar program nutrisi bisa disesuaikan.',
    type: 'info'
  },

  // page 2: frekuensi makan per hari
  {
    id: 'freq_meal',
    title: 'Dalam sehari, biasanya berapa kali kamu makan?',
    subtitle: 'Pilih jawaban yang paling mendekati kebiasaanmu',
    type: 'options',
    name: 'freq_meal',
    options: [
      '3 kali makan besar + 2x cemilan',
      '3 kali makan besar + 1x cemilan',
      '3 kali makan besar',
      '2 kali makan besar',
      '1 kali makan besar',
      '1 kali makan besar + >2x cemilan'
    ]
  },

  // page 3: waktu makan sering dilewatkan
  {
    id: 'miss_meal',
    title: 'Waktu makan apa yang sering kamu lewatkan?',
    type: 'options',
    name: 'miss_meal',
    options: [
      'Sarapan',
      'Makan Siang',
      'Makan Malam',
      'Tidak pernah melewatkan'
    ]
  },

  // page 4: sayur porsi
  {
    id: 'veg_servings',
    title: 'Dalam sehari, berapa kali kamu makan sayur 1 porsi?',
    subtitle: '*1 porsi = 100 gram (5 sdm penuh)',
    type: 'options',
    name: 'veg_servings',
    options: [
      '3 - 4 porsi sehari',
      '2 porsi sehari',
      '1 porsi sehari',
      'Tidak pernah mencapai 1 porsi'
    ]
  },

  // page 5: buah porsi
  {
    id: 'fruit_servings',
    title: 'Dalam sehari, berapa kali kamu makan 1 porsi buah?',
    subtitle: '*1 porsi = 1 buah atau 1 potong besar',
    type: 'options',
    name: 'fruit_servings',
    options: [
      '2 – 3 porsi buah sehari',
      '1 porsi buah sehari',
      'Tidak pernah mencapai 1 porsi sehari'
    ]
  },

  // page 6: konsumsi minuman manis (per bulan)
  {
    id: 'sweet_drinks',
    title: 'Dalam sebulan terakhir, seberapa sering kamu minum minuman manis?',
    type: 'options',
    name: 'sweet_drinks',
    options: [
      'Tidak Pernah',
      '1 kali sebulan',
      '2-3 kali sebulan',
      '1 kali sehari'
    ]
  },

  // page 7: frekuensi makan gorengan
  {
    id: 'fried_food',
    title: 'Dalam sebulan terakhir, seberapa sering kamu makan gorengan?',
    type: 'options',
    name: 'fried_food',
    options: [
      'Tidak Pernah',
      '1 kali sebulan',
      '2-3 kali sebulan',
      '1 kali seminggu',
      '2-3 kali seminggu',
      '>=4 kali seminggu'
    ]
  },

  // page 8: frekuensi fast food
  {
    id: 'fast_food',
    title: 'Dalam sebulan terakhir, seberapa sering kamu makan fast food?',
    type: 'options',
    name: 'fast_food',
    options: [
      'Tidak Pernah',
      '1 kali sebulan',
      '2-3 kali sebulan',
      '1 kali seminggu',
      '2-3 kali seminggu',
      '>=4 kali seminggu'
    ]
  },

  // page 9: optional free text / comments
  {
    id: 'notes',
    title: 'Catatan / hal lain yang ingin kamu sampaikan (opsional)',
    type: 'text',
    name: 'notes',
    placeholder: 'Tulis catatan singkat...'
  }
];

/* ---------- state ---------- */
let pageIndex = 0; // index into pages[]
const answers = {}; // store answers keyed by page.name

/* ---------- render page ---------- */
const pageArea = document.getElementById('pageArea');
const progressBar = document.getElementById('progressBar');
const stepLabel = document.getElementById('stepLabel');
const backBtn = document.getElementById('backBtn');
const nextBtn = document.getElementById('nextBtn');

function renderCurrent(){
  const p = pages[pageIndex];
  pageArea.innerHTML = '';

  // update progress (show 1 .. N where N = pages.length + final summary)
  const totalSteps = pages.length + 1; // +1 for summary
  progressBar.style.width = ((pageIndex)/(totalSteps-1))*100 + '%';
  stepLabel.innerText = `${pageIndex+1} / ${totalSteps}`;

  // build content
  if(p.type === 'info'){
    const wrap = document.createElement('div');
    wrap.innerHTML = `
      <h2 class="q">${p.title}</h2>
      <p class="sub">${p.body || ''}</p>
    `;
    pageArea.appendChild(wrap);
    backBtn.disabled = true;
  }

  else if(p.type === 'options'){
    const q = document.createElement('div');
    q.className = 'qbox';
    q.innerHTML = `<h2 class="q">${p.title}</h2>${p.subtitle?'<p class="sub">'+p.subtitle+'</p>':''}`;
    const opts = document.createElement('div');
    opts.className = 'options';
    p.options.forEach((opt, i)=>{
      const btn = document.createElement('button');
      btn.className = 'opt';
      btn.type = 'button';
      btn.innerText = opt;
      // preselect if exists
      if(answers[p.name] === opt) btn.classList.add('selected');
      btn.addEventListener('click', ()=>{
        // clear other selections
        Array.from(opts.children).forEach(c=>c.classList.remove('selected'));
        btn.classList.add('selected');
        answers[p.name] = opt;
      });
      opts.appendChild(btn);
    });
    q.appendChild(opts);
    pageArea.appendChild(q);
    backBtn.disabled = (pageIndex===0);
  }

  else if(p.type === 'text'){
    const q = document.createElement('div');
    q.className = 'qbox';
    q.innerHTML = `<h2 class="q">${p.title}</h2><textarea id="txtNote" placeholder="${p.placeholder||''}" style="width:100%;min-height:120px;border-radius:10px;border:1px solid #eee;padding:10px;font-size:14px"></textarea>`;
    pageArea.appendChild(q);
    // restore prior
    if(answers[p.name]) document.getElementById('txtNote').value = answers[p.name];
    backBtn.disabled = (pageIndex===0);
  }

  // enable/disable next button depending on whether required answered
  refreshNextState();
}

/* ---------- navigation ---------- */
function refreshNextState(){
  const p = pages[pageIndex];
  if(p.type === 'options'){
    nextBtn.disabled = !answers[p.name];
    nextBtn.innerText = (pageIndex === pages.length-1) ? 'Submit' : 'Continue';
  } else {
    nextBtn.disabled = false;
    nextBtn.innerText = (pageIndex === pages.length-1) ? 'Submit' : 'Continue';
  }
  // back enable
  backBtn.disabled = pageIndex===0;
}

function nextPage(){
  const p = pages[pageIndex];
  // if text, store
  if(p.type === 'text'){
    const val = document.getElementById('txtNote').value.trim();
    answers[p.name] = val;
  }
  // if last page -> show summary
  if(pageIndex === pages.length-1){
    showSummary();
    return;
  }
  pageIndex++;
  renderCurrent();
}

function prevPage(){
  if(pageIndex===0) return;
  pageIndex--;
  renderCurrent();
}

/* ---------- show summary ---------- */
function showSummary(){
  // compute progress fully
  progressBar.style.width = '100%';
  stepLabel.innerText = `Selesai`;

  pageArea.innerHTML = '<h2 class="q">Ringkasan Jawaban</h2><div class="summary" id="summaryList"></div>';
  const list = document.getElementById('summaryList');

  // build summary items in order
  pages.forEach(p=>{
    if(p.type === 'options' || p.type === 'text'){
      const key = p.name;
      const val = answers[key] || '(tidak diisi)';
      const item = document.createElement('div');
      item.className = 'summaryItem';
      item.innerHTML = `<div><strong>${p.title}</strong><div class="meta">${p.subtitle?p.subtitle+'<br>':''}${val}</div></div>`;
      list.appendChild(item);
    }
  });

  // show action (submit)
  const actions = document.createElement('div');
  actions.style.marginTop = '12px';
  actions.innerHTML = `<div style="display:flex;gap:10px"><button class="btn" onclick="submitData()">Kirim</button><button class="btn light" onclick="restart()">Ulangi</button></div>`;
  pageArea.appendChild(actions);

  // disable nav controls
  backBtn.disabled = true;
  nextBtn.disabled = true;
}

/* ---------- submit handler (placeholder) ---------- */
function submitData(){
  // Here you can post 'answers' to server or process locally.
  // For demo, show a confirmation message.
  pageArea.innerHTML = '<h2 class="q">Terima kasih 🎉</h2><p class="sub">Jawabanmu sudah tersimpan. Tim akan menggunakan data ini untuk merencanakan program yang sesuai.</p><div style="margin-top:12px"><button class="btn" onclick="restart()">Kembali ke awal</button></div> <button class="btn" onclick="diet()">Lanjut Diet</button></div>';
  progressBar.style.width = '100%';
  stepLabel.innerText = 'Selesai';
  backBtn.disabled = true;
  nextBtn.disabled = true;
  console.log('Submission payload:', answers);
}
/* ---------- diet ------------- */
function diet()
{
	window.location.href="?d=diet";	
}

/* ---------- restart ---------- */

function restart(){
  // reset state
  for(const k in answers) delete answers[k];
  pageIndex = 0;
  renderCurrent();
  progressBar.style.width = '0%';
  stepLabel.innerText = `1 / ${pages.length + 1}`;
  backBtn.disabled = true;
  nextBtn.disabled = false;
}

/* ---------- initial render ---------- */
renderCurrent();

/* keep next button enabled/disabled when selection changes (delegation) */
document.addEventListener('click', (e)=>{
  if(e.target && e.target.classList.contains('opt')){
    refreshNextState();
  }
});
</script>
</body>
</html>
