<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>TLC Bites — Materi Edukasi Lengkap (22 slide)</title>
<meta name="description" content="Materi edukasi Therapeutic Lifestyle Changes — 22 slide interaktif untuk aplikasi mobile.">
<style>
  :root{
    --accent-green:#2ea153;
    --accent-yellow:#f5c23a;
    --bg:#ffffff;
    --muted:#6b7280;
    --card-shadow: 0 10px 26px rgba(0,0,0,0.06);
    --radius:14px;
    --maxw:460px;
  }
  *{box-sizing:border-box}
  html,body{height:100%;margin:0;font-family:Inter,system-ui,Arial,sans-serif;background:linear-gradient(180deg,#fff 60%, #fbfff5 100%);color:#111}
  .app{max-width:var(--maxw);margin:8px auto;min-height:100vh;display:flex;flex-direction:column;padding:10px}
  .card{background:var(--bg);border-radius:var(--radius);box-shadow:var(--card-shadow);padding:14px;overflow:hidden}
  header{display:flex;align-items:center;gap:12px;margin-bottom:10px}
  .logo{width:52px;height:52px;border-radius:12px;background:linear-gradient(135deg,var(--accent-green),var(--accent-yellow));display:flex;align-items:center;justify-content:center;color:#fff;font-weight:800}
  .headings{flex:1}
  h1{font-size:18px;margin:0}
  p.lead{margin:6px 0;color:var(--muted);font-size:13px}
  .progress-bar{height:8px;background:#eee;border-radius:10px;overflow:hidden;margin:10px 0}
  .progress{height:100%;background:linear-gradient(90deg,var(--accent-green),var(--accent-yellow));width:0%;transition:width .25s}
  /* slide area */
  .slide-wrap{height:64vh;min-height:480px;display:flex;align-items:center;justify-content:center;padding:8px}
  .slide{display:none;flex-direction:column;align-items:center;text-align:center;gap:8px;width:100%}
  .slide.active{display:flex;animation:fade .35s ease}
  @keyframes fade{from{opacity:0;transform:translateY(6px)}to{opacity:1;transform:translateY(0)}}
  .illustration{width:78%;max-width:320px;border-radius:12px;background:#f6fff6;padding:6px}
  .title{font-size:18px;font-weight:800;margin-top:6px}
  .content{font-size:14px;color:var(--muted);line-height:1.55;text-align:left;max-width:100%;padding:0 8px}
  ul.points{padding-left:18px;margin:8px 0}
  .controls{display:flex;gap:8px;margin-top:10px}
  .btn{flex:1;padding:12px;border-radius:10px;border:none;font-weight:700;cursor:pointer}
  .btn.primary{background:var(--accent-green);color:#fff}
  .btn.ghost{background:#fff;border:1px solid #e6f3e9;color:var(--accent-green)}
  .small{font-size:12px;color:var(--muted);text-align:center;margin-top:8px}
  /* quiz */
  .quiz-option{border:1px solid #eee;padding:10px;border-radius:10px;margin:8px 0;cursor:pointer;background:#fff}
  .quiz-option.correct{background:#dff7e6;border-color:var(--accent-green)}
  .quiz-option.wrong{background:#ffecec;border-color:#ff8a8a}
  /* tips checklist */
  .tip{display:flex;align-items:center;gap:10px;padding:10px;background:#fbfff7;border-radius:10px;border-left:4px solid var(--accent-green);margin:8px 0}
  .tip input{transform:scale(1.2)}
  /* summary */
  .summary{max-height:36vh;overflow:auto;padding:6px}
  footer{display:flex;justify-content:space-between;align-items:center;margin-top:10px}
  @media (max-width:420px){ .slide-wrap{min-height:56vh} .illustration{width:90%} }
</style>
</head>
<body>
  <div class="app">

    <div class="card">
      <header>
        <div class="logo">TLC</div>
        <div class="headings">
          <h1>Materi Edukasi TLC — Lengkap</h1>
          <p class="lead">22 halaman interaktif — belajar cepat, praktis, dan bisa disimpan</p>
        </div>
      </header>

      <div class="progress-bar" aria-hidden="true">
        <div id="progress" class="progress" style="width:0%"></div>
      </div>

      <div id="slideContainer" class="slide-wrap">
        <!-- Slides will be injected by JS -->
      </div>

      <div class="controls">
        <button id="prevBtn" class="btn ghost" aria-label="Sebelumnya">← Sebelumnya</button>
        <button id="nextBtn" class="btn primary" aria-label="Lanjut">Lanjut →</button>
      </div>

      <div class="small" id="noteStatus">Progress: <span id="curSlide">0</span> / 22</div>
    </div>

    <footer>
      <div style="font-size:12px;color:#666">TLC Bites — Materi edukasi</div>
      <div style="display:flex;gap:8px">
        <button id="resetBtn" class="btn ghost">Reset Progress</button>
        <button id="exportBtn" class="btn ghost">Ekspor Catatan</button>
      </div>
    </footer>

  </div>

<script>
/*
  22 slides data (title, emoji, image placeholder, html content)
  Replace imageSrc with your own SVG/PNG files (in /img/ or remote)
*/
const slidesData = [
  {id:1, title:'Pengantar — Apa itu Kolesterol? 🧾', imageSrc:'img/slide1_kolesterol.svg',
   content:`<div class="content"><p>Kolesterol adalah lemak (lipid) yang penting untuk fungsi tubuh seperti pembentukan hormon dan dinding sel. Namun, kadar kolesterol yang tinggi meningkatkan risiko penyakit kardiovaskular.</p>
   <ul class="points"><li>Kolesterol total umumnya diukur lewat darah.</li><li>Nilai >200 mg/dL perlu diwaspadai.</li></ul></div>`},

  {id:2, title:'Jenis Kolesterol — LDL & HDL ⚖️', imageSrc:'img/slide2_ldl_hdl.svg',
   content:`<div class="content"><p><strong>LDL</strong> (low-density lipoprotein) = "jahat" &mdash; menumpuk di dinding arteri.<br><strong>HDL</strong> (high-density) = "baik" &mdash; membantu mengangkut lemak ke hati.</p>
   <p>Target klinis: <strong>LDL rendah &amp; HDL cukup</strong>. Rasio LDL/HDL dianjurkan rendah (&lt;2 ideal).</p></div>`},

  {id:3, title:'Mengapa Kolesterol Naik? 🔥', imageSrc:'img/slide3_penyebab.svg',
   content:`<div class="content"><ul class="points"><li>Diet tinggi lemak jenuh &amp; trans (gorengan, makanan proses)</li><li>Obesitas dan lemak visceral</li><li>Kurang aktivitas fisik</li><li>Merokok, alkohol berlebih</li><li>Genetik (hiperkolesterolemia familial)</li></ul></div>`},

  {id:4, title:'Pemeriksaan Kolesterol 🧪', imageSrc:'img/slide4_pemeriksaan.svg',
   content:`<div class="content"><p>Periksa profil lipid meliputi: kolesterol total, LDL, HDL, trigliserida. Puasa 8-12 jam biasanya disarankan sebelum tes.</p>
   <p class="muted">Interpretasi harus oleh tenaga medis; gunakan hasil untuk perencanaan diet/terapi.</p></div>`},

  {id:5, title:'Dampak Jangka Panjang ❤️', imageSrc:'img/slide5_dampak.svg',
   content:`<div class="content"><p>Kolesterol tinggi dapat menyebabkan aterosklerosis — penyempitan pembuluh darah yang meningkatkan risiko serangan jantung, stroke, dan penyakit pembuluh perifer.</p></div>`},

  {id:6, title:'Prinsip Diet TLC 🍽️', imageSrc:'img/slide6_tlc.svg',
   content:`<div class="content"><p>TLC (Therapeutic Lifestyle Changes) fokus pada:</p>
   <ul class="points"><li>Mengurangi lemak jenuh &amp; trans</li><li>Meningkatkan serat &amp; sterol nabati</li><li>Menurunkan berat badan jika diperlukan</li><li>Aktivitas fisik teratur</li></ul></div>`},

  {id:7, title:'Diet Mediterania — Praktis 🥗', imageSrc:'img/slide7_mediterranean.svg',
   content:`<div class="content"><p>Diet mediterania direkomendasikan: banyak sayur &amp; buah, biji-bijian utuh, ikan, kacang, minyak zaitun. Batasi daging merah &amp; makanan olahan.</p>
   <p><strong>Contoh piring sehat:</strong> setengah sayur &amp; buah, seperempat protein, seperempat biji-bijian.</p></div>`},

  {id:8, title:'Lemak: Jenis & Pengaruhnya 🧈', imageSrc:'img/slide8_lemak.svg',
   content:`<div class="content"><ul class="points"><li>Lemak jenuh (mentega, lemak hewani) → naikkan LDL</li><li>Lemak trans (makanan olahan) → buruk untuk LDL/HDL</li><li>Lemak tak jenuh (zaitun, ikan) → baik untuk jantung</li></ul></div>`},

  {id:9, title:'Peran Serat & Fitosterol 🌾', imageSrc:'img/slide9_serat.svg',
   content:`<div class="content"><p>Serat larut (oat, kacang-kacangan) membantu menurunkan LDL. Fitosterol nabati juga membantu menurunkan absorpsi kolesterol.</p></div>`},

  {id:10, title:'Mengurangi Gula & Minuman Manis 🥤', imageSrc:'img/slide10_gula.svg',
   content:`<div class="content"><p>Konsumsi gula berlebih berhubungan dengan obesitas dan profil lipid buruk. Batasi minuman berpemanis dan camilan manis.</p></div>`},

  {id:11, title:'Fast Food & Gorengan 🍟', imageSrc:'img/slide11_fastfood.svg',
   content:`<div class="content"><p>Makanan cepat saji mengandung lemak jenuh, garam, dan kalori tinggi. Konsumsi sering → risiko kolesterol &amp; metabolik meningkat.</p></div>`},

  {id:12, title:'BMI & Status Gizi (IMT) ⚖️', imageSrc:'img/slide12_bmi.svg',
   content:`<div class="content"><p>IMT = BB / (TB x TB) (kg/m²). Kategori: <br>Underweight &lt;18.5 ; Normal 18.5–24.9 ; Overweight 25–29.9 ; Obesitas ≥30.</p></div>`},

  {id:13, title:'Persentase Lemak Tubuh & Risiko ⚠️', imageSrc:'img/slide13_fat.svg',
   content:`<div class="content"><p>Persen lemak tubuh memberi informasi tambahan selain IMT. Visceral fat (lemak perut) terkait penyakit metabolik.</p></div>`},

  {id:14, title:'Aktivitas Fisik untuk Jantung 🏃', imageSrc:'img/slide14_activity.svg',
   content:`<div class="content"><p>Target: 150 menit/minggu aktivitas sedang atau 75 menit/minggu aktivitas tinggi. Sertakan latihan kekuatan 2x/mgg.</p>
   <ul class="points"><li>Manfaat: turunkan LDL, tingkatkan HDL, kontrol berat badan.</li></ul></div>`},

  {id:15, title:'Strategi Memulai Olahraga 🛣️', imageSrc:'img/slide15_start.svg',
   content:`<div class="content"><ul class="points"><li>Mulai perlahan, tingkatkan durasi</li><li>Campurkan kardio &amp; kekuatan</li><li>Tracking: aktivitas 30 menit sehari</li></ul></div>`},

  {id:16, title:'Membaca Label Nilai Gizi 📦', imageSrc:'img/slide16_label.svg',
   content:`<div class="content"><p>Perhatikan: jumlah sajian per kemasan, kalori per sajian, lemak jenuh, gula, dan sodium. Gunakan label untuk memilih produk lebih sehat.</p></div>`},

  {id:17, title:'Mengelola Stres & Tidur 😴', imageSrc:'img/slide17_sleep.svg',
   content:`<div class="content"><p>Stres kronis memengaruhi nafsu makan & hormon. Tidur 7–8 jam mendukung regulasi hormon dan kontrol berat badan.</p></div>`},

  {id:18, title:'Tips Tidur Praktis 🌙', imageSrc:'img/slide18_tipsleep.svg',
   content:`<div class="content"><ul class="points"><li>Tetapkan rutinitas tidur</li><li>Hindari kafein sore hari</li><li>Matikan layar 1 jam sebelum tidur</li></ul></div>`},

  {id:19, title:'Perilaku Sehari-hari & Kebiasaan 🎯', imageSrc:'img/slide19_behavior.svg',
   content:`<div class="content"><ul class="points"><li>Jaga porsi makan</li><li>Hindari ngemil berlebihan</li><li>Minum air cukup</li></ul></div>`},

  {id:20, title:'Contoh Menu & Substitusi 🍽️', imageSrc:'img/slide20_menu.svg',
   content:`<div class="content"><p>Contoh: Pagi (oat + buah), Siang (nasi merah, ikan panggang, sayur), Malam (salad &amp; protein tanpa lemak). Ganti gorengan dengan panggang/kuah.</p></div>`},

  {id:21, title:'Monitoring & Follow-up 🩺', imageSrc:'img/slide21_monitor.svg',
   content:`<div class="content"><p>Periksa profil lipid secara berkala, diskusikan hasil dengan dokter/gizi, dan catat perubahan berat badan & aktivitas.</p></div>`},

  {id:22, title:'Kesimpulan & Kuis Akhir ✅', imageSrc:'img/slide22_quiz.svg',
   content:`<div class="content"><p>Ringkas: ubah pola makan, aktif bergerak, perbaiki tidur, dan pantau hasil. Selesaikan kuis singkat di bawah untuk menguji pemahamanmu.</p>
   <hr>
   <div id="quizArea">
     <p><strong>1.</strong> Kolesterol jahat disebut ... ?</p>
     <div class="quiz-option" data-answer="LDL">LDL</div>
     <div class="quiz-option" data-answer="HDL">HDL</div>

     <p style="margin-top:10px"><strong>2.</strong> Target aktivitas mingguan minimal adalah ... ?</p>
     <div class="quiz-option" data-answer="150">150 menit sedang</div>
     <div class="quiz-option" data-answer="75">75 menit sedang</div>

     <p style="margin-top:10px"><strong>3.</strong> Durasi tidur ideal per malam kira-kira ... ?</p>
     <div class="quiz-option" data-answer="7-8">7-8 jam</div>
     <div class="quiz-option" data-answer="4-5">4-5 jam</div>

     <div id="quizResult" style="margin-top:12px;font-weight:800"></div>
   </div>
   </div>`}
];

// render slides
const container = document.getElementById('slideContainer');
slidesData.forEach((s, idx) => {
  const div = document.createElement('div');
  div.className = 'slide';
  div.setAttribute('data-index', idx);
  div.innerHTML = `
    <img class="illustration" src="${s.imageSrc}" alt="Illustration ${s.id}" onerror="this.style.display='none'">
    <div class="title">${s.title}</div>
    <div class="content">${s.content}</div>
  `;
  container.appendChild(div);
});

// state
const slides = document.querySelectorAll('.slide');
const prevBtn = document.getElementById('prevBtn');
const nextBtn = document.getElementById('nextBtn');
const progress = document.getElementById('progress');
const curSlideText = document.getElementById('curSlide');
let idx = Number(localStorage.getItem('tlc_slide_idx') || 0);

// show function
function show(i){
  if(i < 0) i = 0;
  if(i >= slides.length) i = slides.length - 1;
  slides.forEach((sl, n) => sl.classList.toggle('active', n === i));
  prevBtn.disabled = i === 0;
  nextBtn.disabled = i === slides.length - 1;
  const pct = ((i + 1) / slides.length) * 100;
  progress.style.width = pct + '%';
  curSlideText.innerText = (i + 1) + ' / ' + slides.length;
  idx = i;
  localStorage.setItem('tlc_slide_idx', idx.toString());
  // if last slide, enable quiz handlers
  if(i === slides.length - 1) initQuiz();
}
prevBtn.addEventListener('click', () => show(idx - 1));
nextBtn.addEventListener('click', () => show(idx + 1));

// init quiz for last slide
function initQuiz(){
  const quizArea = document.getElementById('quizArea');
  if(!quizArea) return;
  // prevent double init
  if(quizArea.dataset.init === '1') return;
  quizArea.dataset.init = '1';
  const options = quizArea.querySelectorAll('.quiz-option');
  const result = document.getElementById('quizResult');
  let answers = {};
  // we'll map correct answers (simple mapping)
  const correctMap = {
    1: 'LDL',
    2: '150',
    3: '7-8'
  };
  options.forEach(opt => {
    opt.addEventListener('click', () => {
      // determine question by walking previous siblings
      // simpler: check text content and map
      const text = opt.textContent.trim();
      // determine which q by looking at previousElementSibling paragraphs
      // find parent node and count which question this belongs to
      const p = opt.parentElement.previousElementSibling;
      // but simpler: match by opt.dataset.answer (we stored)
      // we'll just compare opt.dataset.answer to allowed correctMap values
      // find q key by nearest heading text (less robust but ok)
      // give immediate feedback
      if(opt.classList.contains('selected')) return; // already answered
      options.forEach(o => o.classList.remove('selected','correct','wrong'));
      opt.classList.add('selected');
      // Determine which question: find the question number above this option
      // Search upward for preceding <p> with strong number
      let qNum = null;
      let el = opt;
      while(el && el !== quizArea){
        el = el.previousElementSibling;
        if(!el) break;
        if(el.tagName.toLowerCase() === 'p' && el.textContent.trim().match(/^\d+\./)){
          qNum = Number(el.textContent.trim().split('.')[0]);
          break;
        }
      }
      if(!qNum){ // fallback: heuristic by position of option among all options
        // guess qNum by index of opt among options: 0-1 => q1, 2-3 => q2, 4-5 => q3
        const all = Array.from(options);
        const pos = all.indexOf(opt);
        qNum = Math.floor(pos/2) + 1;
      }
      const chosen = opt.dataset.answer;
      const correct = correctMap[qNum];
      if(chosen === correct){
        opt.classList.add('correct');
        result.textContent = `Jawaban benar untuk soal ${qNum}! 🎉`;
      } else {
        opt.classList.add('wrong');
        result.textContent = `Soal ${qNum}: jawaban belum tepat. Jawaban benar: ${correct}`;
      }
    });
  });
}

// tips checklist in the last slide (and saved globally)
function initTipsGlobal(){
  // create tips UI in slide 22 if not exists (we already had tips earlier in one slide)
  // we'll also wire up tip-check inputs across the app
  document.querySelectorAll('.tip input').forEach((inp, i) => {
    const key = 'tlc_tip_' + i;
    inp.checked = localStorage.getItem(key) === '1';
    inp.addEventListener('change', () => localStorage.setItem(key, inp.checked ? '1' : '0'));
  });
}

// initialize
show(idx);
initTipsGlobal();

// Reset & export
document.getElementById('resetBtn').addEventListener('click', ()=>{
  if(!confirm('Reset progress dan checklist?')) return;
  localStorage.removeItem('tlc_slide_idx');
  // clear tips tlc_tip_
  for(let k in localStorage){
    if(k.startsWith('tlc_tip_')) localStorage.removeItem(k);
  }
  location.reload();
});
document.getElementById('exportBtn').addEventListener('click', ()=>{
  // simple export: text of checked tips + current slide
  const tips = [];
  document.querySelectorAll('.tip input').forEach((inp,i)=>{
    if(inp.checked) tips.push(inp.parentElement.textContent.trim());
  });
  const data = {
    currentSlide: idx + 1,
    checkedTips: tips
  };
  const blob = new Blob([JSON.stringify(data, null, 2)], {type: 'application/json'});
  const url = URL.createObjectURL(blob);
  const a = document.createElement('a'); a.href = url; a.download = 'tlc_progress.json'; a.click(); URL.revokeObjectURL(url);
});

// enable keyboard navigation (optional)
document.addEventListener('keydown', (e) => {
  if(e.key === 'ArrowRight') show(idx + 1);
  if(e.key === 'ArrowLeft') show(idx - 1);
});

// optional: simple swipe for mobile
let touchStartX = null;
document.getElementById('slideContainer').addEventListener('touchstart', (e)=> {
  touchStartX = e.changedTouches[0].clientX;
});
document.getElementById('slideContainer').addEventListener('touchend', (e)=> {
  if(touchStartX === null) return;
  const touchEndX = e.changedTouches[0].clientX;
  const diff = touchStartX - touchEndX;
  if(Math.abs(diff) > 40){
    if(diff > 0) show(idx + 1);
    else show(idx - 1);
  }
  touchStartX = null;
});
</script>
</body>
</html>
