<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Entry Data Waktu Tidur</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f8fff8;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .container {
      width: 90%;
      max-width: 420px;
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.15);
      padding: 20px;
    }
    h2 {
      text-align: center;
      margin-bottom: 18px;
    }
    .box {
      display: flex;
      justify-content: space-between;
      gap: 10px;
    }
    .inputBox {
      flex: 1;
      background: #fafafa;
      border-radius: 12px;
      padding: 14px;
      text-align: center;
      box-shadow: inset 0 2px 4px rgba(0,0,0,0.05);
    }
    .inputBox h4 {
      font-size: 14px;
      margin-bottom: 10px;
    }
    input[type="time"] {
      width: 100%;
      font-size: 18px;
      padding: 6px;
      border-radius: 8px;
      border: 1px solid #ccc;
    }
    .result {
      margin-top: 20px;
      text-align: center;
      padding: 12px;
      border-radius: 10px;
      font-weight: bold;
      font-size: 16px;
      display: none;
    }
    .normal { background: #e6f9e8; color: #2c7a2c; }
    .kurang { background: #fff3cd; color: #856404; }
    .btn {
      margin-top: 20px;
      width: 100%;
      padding: 12px;
      background: #2ea153;
      color: white;
      font-size: 16px;
      font-weight: bold;
      border: none;
      border-radius: 10px;
      cursor: pointer;
    }
    .btn:hover { background: #268a46; }
  </style>
</head>
<body>
  <div class="container">
    <h2>Entry Data Waktu Tidur</h2>
    <div class="box">
      <div class="inputBox">
        <h4>Jam berapa kamu tidur?</h4>
        <input type="time" id="sleepTime">
      </div>
      <div class="inputBox">
        <h4>Jam berapa kamu bangun?</h4>
        <input type="time" id="wakeTime">
      </div>
    </div>
    <div id="resultBox" class="result"></div>
    <button class="btn" onclick="calculateSleep()">Continue</button>
  </div>

  <script>
    function calculateSleep() {
      const sleep = document.getElementById('sleepTime').value;
      const wake = document.getElementById('wakeTime').value;
      const resultBox = document.getElementById('resultBox');

      if (!sleep || !wake) {
        alert("Isi dulu jam tidur dan bangun!");
        return;
      }

      const [sh, sm] = sleep.split(':').map(Number);
      const [wh, wm] = wake.split(':').map(Number);

      let start = sh * 60 + sm;
      let end = wh * 60 + wm;

      if (end <= start) end += 24 * 60; // kalau bangunnya lewat tengah malam

      const duration = (end - start) / 60;
      let category = "";
      let cls = "";

      if (duration >= 7 && duration <= 8) {
        category = `Normal ✅ (${duration.toFixed(1)} jam)`;
        cls = "normal";
      } else {
        category = `Kurang Tidur 😴 (${duration.toFixed(1)} jam)`;
        cls = "kurang";
      }

      resultBox.textContent = `Kamu tidur ${duration.toFixed(1)} jam — ${category}`;
      resultBox.className = "result " + cls;
      resultBox.style.display = "block";
    }
  </script>
</body>
</html>
