<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>TLC Bites — Aktivitas Fisik</title>
<style>
  :root{
    --accent-green: #2ea153;
    --accent-yellow: #f5c23a;
    --bg: #ffffff;
    --muted:#f3faf3;
    --text:#1f2937;
    --muted-text:#6b7280;
  }
  html,body{height:100%;margin:0;font-family:Inter, system-ui, sans-serif;}
  body{background:linear-gradient(180deg,#fff 60%, #fbfff5 100%);display:flex;align-items:center;justify-content:center;padding:16px;}
  .decor {position:fixed;border-radius:50%;pointer-events:none;z-index:0;opacity:0.08}
  .decor.left{width:200px;height:200px;left:-70px;top:-70px;background:var(--accent-green)}
  .decor.right{width:160px;height:160px;right:-60px;bottom:-60px;background:var(--accent-yellow)}
  .wrap{width:100%;max-width:420px;z-index:1}
  .card{background:var(--bg);border-radius:14px;box-shadow:0 8px 24px rgba(0,0,0,0.08);padding:18px}
  .progress{height:8px;background:#eee;border-radius:6px;overflow:hidden;margin-bottom:10px}
  .progressBar{height:100%;background:var(--accent-green);width:70%} /* contoh step ke-3 */
  .title{font-size:18px;font-weight:700;text-align:center;margin:12px 0;color:var(--text)}
  .subtitle{font-size:14px;color:var(--muted-text);text-align:center;margin-bottom:18px}
  .choices{display:flex;flex-direction:column;gap:12px}
  .choice{display:flex;align-items:center;gap:12px;padding:14px;border:1px solid #e2e2e2;border-radius:12px;background:#fafafa;cursor:pointer;transition:.2s}
  .choice:hover{background:#f0fff4}
  .choice.selected{border-color:var(--accent-green);background:#f3fff8;box-shadow:0 4px 12px rgba(46,161,83,0.15)}
  .choice strong{display:block;margin-bottom:4px;color:var(--text)}
  .choice img{width:40px;height:40px;border-radius:8px;object-fit:cover;background:#fff}
  .btn{margin-top:20px;width:100%;padding:14px;border:none;border-radius:10px;background:var(--accent-green);color:#fff;font-size:16px;font-weight:700;cursor:pointer}
</style>
</head>
<body>
  <div class="decor left"></div>
  <div class="decor right"></div>

  <div class="wrap">
    <div class="card">
      <!-- Progress bar -->
      <div class="progress"><div class="progressBar"></div></div>

      <!-- Pertanyaan -->
      <div class="title">Entry Aktivitas Fisik</div>
      <div class="subtitle">Seberapa aktif kamu dalam 2 minggu terakhir?</div>

      <!-- Pilihan -->
      <div class="choices" id="choices">
        <div class="choice" onclick="selectChoice(this, 'Tidak aktif')">
          <img src="https://img.icons8.com/emoji/48/person-in-bed.png" alt="tidak aktif">
          <div>
            <strong>Tidak aktif</strong>
            Nafasku ngos-ngosan saat aku harus naik tangga
          </div>
        </div>
        <div class="choice" onclick="selectChoice(this, 'Sedikit aktif')">
          <img src="https://img.icons8.com/emoji/48/person-walking.png" alt="sedikit aktif">
          <div>
            <strong>Sedikit aktif</strong>
            Kadang aku memilih parkir agak jauh agar bisa jalan ke kelas
          </div>
        </div>
        <div class="choice" onclick="selectChoice(this, 'Aktif')">
          <img src="https://img.icons8.com/emoji/48/person-running.png" alt="aktif">
          <div>
            <strong>Aktif</strong>
            Aku rutin berolahraga 1-2 kali seminggu
          </div>
        </div>
        <div class="choice" onclick="selectChoice(this, 'Sangat aktif')">
          <img src="https://img.icons8.com/emoji/48/person-lifting-weights.png" alt="sangat aktif">
          <div>
            <strong>Sangat aktif</strong>
            Aku sangat menyukai olahraga, hampir setiap hari aku melakukannya
          </div>
        </div>
      </div>

      <!-- Tombol -->
      <button class="btn" onclick="submitChoice()">Lanjut ➡️</button>
    </div>
  </div>

<script>
let selected = null;
function selectChoice(el, value){
  document.querySelectorAll('.choice').forEach(c=>c.classList.remove('selected'));
  el.classList.add('selected');
  selected = value;
}
function submitChoice(){
  if(!selected){ alert('Pilih salah satu dulu ya'); return; }
  alert('Pilihanmu: '+selected);
  // TODO: pindah ke halaman berikutnya
}
</script>
</body>
</html>
