<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>TLC Bites - Dashboard</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
      padding: 0;
      background: #fafafa;
      color: #333;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      position: relative;
      overflow-x: hidden;
    }

    header {
      text-align: center;
      padding: 15px;
      font-weight: bold;
      font-size: 18px;
      background: #ffffffcc;
      backdrop-filter: blur(6px);
      box-shadow: 0 2px 6px rgba(0,0,0,0.08);
      position: sticky;
      top: 0;
      z-index: 10;
    }

    .logo-section {
      text-align: center;
      padding: 30px 15px 10px;
      position: relative;
      z-index: 2;
    }

    /* Dekorasi wave hijau-oranye */
    .decor-top {
      position: absolute;
      top: 0; left: 0;
      width: 100%;
      height: 180px;
      background: linear-gradient(135deg, #4caf50 0%, #ff9800 100%);
      clip-path: polygon(0 0, 100% 0, 100% 65%, 0 100%);
      z-index: 1;
      opacity: 0.15;
    }

    .decor-bottom {
      position: absolute;
      bottom: 0; left: 0;
      width: 100%;
      height: 150px;
      background: linear-gradient(135deg, #ff9800 0%, #4caf50 100%);
      clip-path: polygon(0 35%, 100% 0, 100% 100%, 0 100%);
      z-index: 1;
      opacity: 0.12;
    }

    .logo-section img.avatar {
      width: 120px;
      height: auto;
      margin-bottom: 10px;
    }

    .logo-section img.logo {
      width: 110px;
      height: auto;
    }

    .logo-section h2 {
      font-size: 22px;
      margin: 10px 0 4px;
      color: #ff9800;
    }

    .logo-section p {
      font-size: 12px;
      color: #4caf50;
      margin: 0;
    }

    .grid-menu {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 18px;
      padding: 25px 20px 40px;
      flex: 1;
      z-index: 2;
    }

    .menu-item {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 3px 8px rgba(0,0,0,0.05);
      text-align: center;
      padding: 15px 10px;
      transition: transform 0.2s;
      border: 2px solid transparent;
    }

    .menu-item:hover {
      transform: scale(1.05);
      border: 2px solid #4caf50;
    }

    .menu-item img {
      width: 50px;
      height: 50px;
      margin-bottom: 10px;
    }

    .menu-item p {
      font-size: 13px;
      margin: 0;
      font-weight: 600;
      color: #333;
    }
  .Dashboard {
}
  </style>
</head>
<body class="Dashboard">

  <!-- Dekorasi -->
  <div class="decor-top"></div>
  <div class="decor-bottom"></div>

<header>
    DASHBOARD
  </header>

  <div class="logo-section">
    <p>
      <!-- Avatar GIF -->
    <img src="../images/cat-normal.gif" alt="Avatar Kucing" class="avatar"></p>
<?php /*?>    <p><img src="../images/Up-2.png" alt="TLC Bites Logo" width="480" height="480" class="logo">
<?php */?>      
      <!-- Logo TLC Bites -->
    </p>
    <h2>TLC Bites</h2>
    <p>Balanced diet, Training, Exercise, and Self-management</p>
  </div>

  <div class="grid-menu">
    <div class="menu-item">
      <img src="https://img.icons8.com/color/96/user-male-circle.png" alt="Profil">
      <p>Profil</p>
    </div>

    <div class="menu-item" onClick="klik_edu()">
      <img src="https://img.icons8.com/color/96/open-book--v1.png" alt="Edukasi">
      <p>Edukasi</p>
    </div>

    <div class="menu-item" onClick="klik_ass()" >
      <img src="https://img.icons8.com/color/96/task.png" alt="Assessment Gizi">
      <p>Assessment</p>
    </div>

    <div class="menu-item">
      <img src="https://img.icons8.com/color/96/combo-chart--v1.png" alt="Monitoring">
      <p>Monitoring</p>
    </div>

    <div class="menu-item">
      <img src="https://img.icons8.com/color/96/report-card.png" alt="Laporan">
      <p>Laporan</p>
    </div>

    <div class="menu-item" onClick="klik_kuis()">
      <img src="https://img.icons8.com/?size=100&id=56576&format=png&color=000000" alt="Kuis">
      <p>Kuis</p>
    </div>

    <div class="menu-item">
      <img src="https://img.icons8.com/color/96/speech-bubble-with-dots.png" alt="Grup Chat">
      <p>Grup Chat</p>
    </div>

    <div class="menu-item">
      <img src="https://img.icons8.com/color/96/cat.png" alt="Avatar">
      <p>Avatar</p>
    </div>
    
    <div class="menu-item" onClick="klik_out()">
      <img src="https://img.icons8.com/?size=100&id=2445&format=png&color=000000" alt="logout">
      <p>Keluar</p>
    </div>
  </div>

</body>
<script type="application/javascript">
function klik_ass()
	{
			window.location.href="?d=assesment";
	}

function klik_out()
	{
			window.location.href="?d=logout";
	}
function klik_edu()
	{
			window.location.href="?d=edukasi";
	}
function klik_kuis()
	{
			window.location.href="?d=kuis";
	}

</script>
</html>
