<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Daftar - TLC Bites (Onboarding)</title>
  <style>
    :root{
      --green:#28a745;
      --orange:#ff8000;
      --bg:#fafafa;
      --card:#ffffff;
      --muted:#666;
      --radius:16px;
      --max-width:420px;
    }

    html,body{
      height:100%;
      margin:0;
      font-family: "Segoe UI", system-ui, -apple-system, "Helvetica Neue", Arial;
      background: var(--bg);
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
    }

    /* wave decor - top & bottom subtle */
    .decor-top{
      position:fixed;
      left:0; right:0; top:0;
      height:170px;
      background: linear-gradient(135deg, rgba(40,167,69,0.14), rgba(255,128,0,0.14));
      clip-path: polygon(0 0,100% 0,100% 60%, 0 100%);
      pointer-events:none;
      z-index:0;
    }
    .decor-bottom{
      position:fixed;
      left:0; right:0; bottom:0;
      height:140px;
      background: linear-gradient(135deg, rgba(255,128,0,0.12), rgba(40,167,69,0.12));
      clip-path: polygon(0 40%, 100% 0, 100% 100%, 0 100%);
      pointer-events:none;
      z-index:0;
    }

    /* container centered mobile */
    .wrap {
      min-height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:20px;
      z-index:1;
      position:relative;
    }

    .card {
      width:100%;
      max-width:var(--max-width);
      background:var(--card);
      border-radius:var(--radius);
      box-shadow:0 8px 30px rgba(0,0,0,0.08);
      overflow:hidden;
      position:relative;
    }

    /* top header: progress fraction & steps */
    .card-header{
      padding:12px 16px;
      display:flex;
      align-items:center;
      justify-content:space-between;
      background: #ffffffcc;
      backdrop-filter: blur(4px);
      border-bottom:1px solid rgba(0,0,0,0.04);
    }
    .title{
      font-weight:700;
      font-size:15px;
      letter-spacing:0.4px;
    }
    .fraction{
      font-size:13px;
      color:var(--muted);
    }

    /* progress bar small */
    .progress-bar{
      height:6px;
      background: #eee;
      border-radius:8px;
      overflow:hidden;
      margin:8px 16px;
    }
    .progress-bar > i{
      display:block;
      height:100%;
      width:0%;
      background: linear-gradient(90deg,var(--green),var(--orange));
      transition:width .35s ease;
    }

    /* stage area */
    .slides {
      padding: 18px 18px 14px;
      min-height: 420px;
      display:block;
      position:relative;
    }

    .slide {
      display:none;
      text-align:center;
      animation: slideFade .36s ease;
      position:relative;
    }
    .slide.active { display:block; }

    @keyframes slideFade{
      from { opacity:0; transform:translateX(10px); }
      to { opacity:1; transform:translateX(0); }
    }

    /* avatar animation container */
    .avatar-wrap{
      display:flex;
      align-items:center;
      justify-content:center;
    }
    .avatar {
      width:120px;
      height:auto;
      display:block;
      transform-origin:center;
      animation: bob 3s ease-in-out infinite;
      user-select:none;
      -webkit-user-drag:none;
    }
    @keyframes bob {
      0% { transform: translateY(0); }
      50% { transform: translateY(-8px); }
      100% { transform: translateY(0); }
    }

    .logo-small{
      width:88px;
      height:auto;
      margin:6px auto 0;
      display:block;
    }

    h2.prompt{
      font-size:18px;
      margin:12px 12px 8px;
      color:#222;
      line-height:1.2;
    }
    p.helper{
      margin:0 20px 14px;
      color:var(--muted);
      font-size:13px;
    }

    /* input styles */
    .field{
      margin:14px 18px;
      text-align:left;
    }
    .field label{
      display:block;
      font-size:13px;

      color:var(--muted);
      margin-bottom:6px;
      font-weight:600;
    }
    .field input[type="text"],
    .field input[type="email"],
    .field input[type="password"],
    .field select,
    .picker {
      width:100%;
      padding:12px 12px;
      border-radius:10px;
      border:1px solid #e0e0e0;
      background:#fff;
      font-size:15px;
      outline:none;
      box-sizing:border-box;
    }

    /* date pickers arranged in row */
    .row {
      display:flex;
      gap:10px;
      margin-top:6px;
    }
    .row .picker { flex:1; }

    /* gender buttons */
    .gender {
      display:flex;
      gap:10px;
      justify-content:center;
      margin-top:8px;
    }
    .gender button {
      flex:1;
      padding:12px 8px;
      border-radius:10px;
      border:1px solid #eee;
      background:#fff;
      font-weight:700;
      color:#333;
      cursor:pointer;
    }
    .gender button.selected{
      background:linear-gradient(90deg,var(--green),var(--orange));
      color:#fff;
      border:none;
      box-shadow:0 6px 18px rgba(0,0,0,0.08);
    }

    /* nav */
    .nav {
      display:flex;
      gap:12px;
      padding:14px;
      align-items:center;
      justify-content:space-between;
      border-top:1px solid rgba(0,0,0,0.04);
    }
    .nav .left{
      font-size:13px;
      color:var(--muted);
    }
    .btn {
      padding:10px 14px;
      border-radius:10px;
      border:none;
      font-weight:700;
      cursor:pointer;
      min-width:100px;
    }
    .btn.next {
      background: linear-gradient(90deg,var(--green),var(--orange));
      color:#fff;
      box-shadow:0 8px 18px rgba(0,0,0,0.08);
    }
    .btn.prev {
      background:#f0f0f0;
      color:#333;
    }
    .btn.start {
      background:var(--green);
      color:#fff;
    }
    .btn.primary {
      background: linear-gradient(90deg,var(--green),var(--orange));
      color:white;
      width:100%;
      padding:12px;
      border-radius:12px;
      font-size:16px;
    }

    /* final screen big button */
    .final-wrap { padding:22px; }
    .final-wrap p { color:var(--muted); font-size:14px; margin-bottom:16px; text-align:center; }

    /* small step dots mobile */
    .dots{
      display:flex;
      gap:6px;
      justify-content:center;
      margin-top:10px;
    }
    .dots span{
      width:7px; height:7px; background:#eee; display:inline-block; border-radius:99px;
    }
    .dots span.active{ background: linear-gradient(90deg,var(--green),var(--orange)); width:22px; height:7px; border-radius:8px; transition:all .24s; }

    /* responsive */
    @media(min-width:520px){
      body{ background:#fff; }
      .card{ box-shadow:0 10px 40px rgba(0,0,0,0.08); }
      .slides { min-height:520px; }
    }
  </style>
</head>
<body>
  <div class="decor-top" aria-hidden="true"></div>
  <div class="decor-bottom" aria-hidden="true"></div>

  <div class="wrap">
    <div class="card" role="region" aria-label="Onboarding Daftar Akun TLC Bites">
      <div class="card-header">
        <div class="title">Buat Akun Baru</div>
        <div class="fraction" id="fraction">1 / 8</div>
      </div>

      <div class="progress-bar" aria-hidden="true"><i id="progressFill"></i></div>

      <div class="slides" id="slides">
        <!-- Slide 1: Opening -->
        <div class="slide active" data-step="1">
          <div class="avatar-wrap">
            <img class="avatar" src="../images/cat-normal.gif" alt="Avatar Kucing TLC">
          </div>
          <img class="logo-small" src="../images/Up-Full-Black-trans-small.png" alt="TLC Bites Logo">
          <h2 class="prompt">Hai...</h2>
          <p class="helper">Sebelum lebih jauh, mari kita saling mengenal.</p>

          <div style="padding:0 20px; margin-top:18px;">
            <button class="btn start" id="startBtn" type="button">Mulai</button>
          </div>
                </div>

        <!-- Slide 2: Nama Lengkap -->
        <div class="slide" data-step="2">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Siapa nama lengkapmu?</h2>
          <p class="helper">Tulis sesuai dengan identitas kamu.</p>

          <div class="field">
            <label for="fullname">Nama Lengkap</label>
            <input id="fullname" type="text" placeholder="Contoh: Siti Nurhaliza">
          </div>
        </div>

        <!-- Slide 3: Nama Panggilan -->
        <div class="slide" data-step="3">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Kasih tau nama panggilanmu</h2>
          <p class="helper">Nama yang akan muncul dalam interaksi dan notifikasi.</p>

          <div class="field">
            <label for="nickname">Nama Panggilan</label>
            <input id="nickname" type="text" placeholder="Contoh: Siti / Donny">
          </div>
        </div>

        <!-- Slide 4: Tahun Lahir -->
        <div class="slide" data-step="4">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Pilih tahun lahirmu</h2>
          <p class="helper">Gunakan scroll untuk memilih tahun.</p>

          <div class="field">
            <label for="year">Tahun</label>
            <select id="year" class="picker" aria-label="Pilih tahun">
              <!-- JS isi tahun -->
            </select>
          </div>
        </div>

        <!-- Slide 5: Bulan Lahir -->
        <div class="slide" data-step="5">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Pilih bulan lahirmu</h2>
          <p class="helper">Bulan lahir membantu perhitungan usia.</p>

          <div class="field">
            <label for="month">Bulan</label>
            <select id="month" class="picker" aria-label="Pilih bulan">
              <option value="">-- Pilih Bulan --</option>
              <option value="1">Januari</option>
              <option value="2">Februari</option>
              <option value="3">Maret</option>
              <option value="4">April</option>
              <option value="5">Mei</option>
              <option value="6">Juni</option>
              <option value="7">Juli</option>
              <option value="8">Agustus</option>
              <option value="9">September</option>
              <option value="10">Oktober</option>
              <option value="11">November</option>
              <option value="12">Desember</option>
            </select>
          </div>
        </div>

        <!-- Slide 6: Tanggal Lahir -->
        <div class="slide" data-step="6">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Pilih tanggal lahirmu</h2>
          <p class="helper">Pilih tanggal (1 - 31).</p>

          <div class="field">
            <label for="day">Tanggal</label>
            <select id="day" class="picker" aria-label="Pilih tanggal">
              <option value="">-- Pilih Tanggal --</option>
              <!-- JS isi hari -->
            </select>
          </div>
        </div>

        <!-- Slide 7: Gender -->
        <div class="slide" data-step="7">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Pilih Gendermu</h2>
          <p class="helper">Informasi ini membantu personalisasi konten.</p>

          <div style="padding:0 18px;">
            <div class="gender" role="radiogroup" aria-label="Pilih gender">
              <button type="button" data-value="L" id="genderM">Male</button>
              <button type="button" data-value="P" id="genderF">Female</button>
            </div>
          </div>
          <h2 class="prompt">Informasi Akun</h2>
          <div class="field">
            <label for="email">Email</label>
            <input id="email" type="email" placeholder="siti@gmail.com" required>
          </div>
          <div class="field">
            <label for="password">Kata Sandi</label>
            <input id="password" type="password" placeholder="!@Abc?" required>
          </div>

        </div>

        <!-- Slide 8: Final -->
        <div class="slide" data-step="8">
          <div class="avatar-wrap"><img class="avatar" src="../images/cat-normal.gif" alt=""></div>
          <h2 class="prompt">Siap untuk memulai?</h2>
          <p class="helper">Pastikan data sudah benar. Tekan Daftar untuk membuat akun.</p>
          
          <div class="final-wrap">
            <p id="summaryText" style="font-weight:600; color:#333;"></p>
            <button class="btn primary" id="submitBtn" type="button">DAFTAR</button>
          </div>
        </div>
      </div>

      <div class="nav">
        <div class="left">
          <button class="btn prev" id="prevBtn" type="button" aria-label="Sebelumnya">Kembali</button>
        </div>
        <div style="flex:1; text-align:center; font-size:13px; color:var(--muted)" id="stepLabel">Langkah 1 dari 8</div>
        <div style="text-align:right;">
          <button class="btn next" id="nextBtn" type="button" aria-label="Selanjutnya">Selanjutnya</button>
        </div>
      </div>

    </div>
  </div>

  <script>
    // Basic onboarding slide logic with swipe support
    (function(){
      const slides = Array.from(document.querySelectorAll('.slide'));
      const total = slides.length;
      const prevBtn = document.getElementById('prevBtn');
      const nextBtn = document.getElementById('nextBtn');
      const startBtn = document.getElementById('startBtn');
      const progressFill = document.getElementById('progressFill');
      const fraction = document.getElementById('fraction');
      const stepLabel = document.getElementById('stepLabel');
      const summaryText = document.getElementById('summaryText');

      let index = 0;

      // form elements
      const fullname = document.getElementById('fullname');
      const nickname = document.getElementById('nickname');
      const year = document.getElementById('year');
      const month = document.getElementById('month');
      const day = document.getElementById('day');
      const genderM = document.getElementById('genderM');
      const genderF = document.getElementById('genderF');
      const submitBtn = document.getElementById('submitBtn');
	  const email = document.getElementById('email');
	  const pass = document.getElementById('password');

      // populate year and day
      (function populateDate(){
        const currentYear = new Date().getFullYear();
        for(let y=currentYear; y>=1900; y--){
          const opt = document.createElement('option');
          opt.value = y;
          opt.textContent = y;
          year.appendChild(opt);
        }
        for(let d=1; d<=31; d++){
          const opt = document.createElement('option');
          opt.value = d;
          opt.textContent = d;
          day.appendChild(opt);
        }
      })();

      function updateUI(){
        slides.forEach((s,i)=>{
          s.classList.toggle('active', i===index);
        });
        const pct = Math.round(((index+1)/total) * 100) + '%';
        progressFill.style.width = pct;
        fraction.textContent = (index+1) + " / " + total;
        stepLabel.textContent = "Langkah " + (index+1) + " dari " + total;
        // prev visibility
        prevBtn.style.visibility = index === 0 ? 'hidden' : 'visible';
        // next label
        nextBtn.textContent = index === total-1 ? 'Selesai' : 'Selanjutnya';
        // show summary on final
        if(index === total-1){
          const nFull = fullname.value || '-';
          const nNick = nickname.value || '-';
          const y = year.value || '-';
          const m = month.options[month.selectedIndex]?.text || '-';
          const d = day.value || '-';
          const g = (genderM.classList.contains('selected') ? 'Male' : (genderF.classList.contains('selected') ? 'Female' : '-'));
          summaryText.textContent = `Nama: ${nFull} (${nNick}) • Lahir: ${d} ${m} ${y} • Gender: ${g}`;
        }
      }

      // next / prev handlers
      nextBtn.addEventListener('click', ()=> {
        if (index < total-1) {
          // simple validation on certain steps
          if(index === 1 && !fullname.value.trim()){
            alert('Tolong isi nama lengkap dulu.');
            return;
          }
          if(index === 2 && !nickname.value.trim()){
            alert('Tolong isi nama panggilan.');
            return;
          }
          if(index === 3 && !year.value){
            alert('Pilih tahun lahir.');
            return;
          }
          if(index === 4 && !month.value){
            alert('Pilih bulan lahir.');
            return;
          }
          if(index === 5 && !day.value){
            alert('Pilih tanggal lahir.');
            return;
          }
          if(index === 6 && !(genderM.classList.contains('selected') || genderF.classList.contains('selected'))){
            alert('Pilih gender.');
            return;
          }
		  if(index === 6 && !email.value){
            alert('Masukkan Email.');
            return;
          }
		  if(index === 6 && !pass.value){
            alert('Masukkan Kata Kunci.');
            return;
          }
          index++;
          updateUI();
        } else {
          // finished
          alert('Selesai — siap mengirim data pendaftaran.');
        }
      });
      prevBtn.addEventListener('click', ()=> {
        if(index > 0){ index--; updateUI(); }
      });

      // start button
      startBtn && startBtn.addEventListener('click', ()=>{
        index = 1; updateUI();
      });

      // gender selection
      genderM.addEventListener('click', ()=> {
        genderM.classList.add('selected');
        genderF.classList.remove('selected');
      });
      genderF.addEventListener('click', ()=> {
        genderF.classList.add('selected');
        genderM.classList.remove('selected');
      });

      // submit (final)
      submitBtn.addEventListener('click', ()=>{
        // simple collection
        const payload = {
          fullname: fullname.value.trim(),
          nickname: nickname.value.trim(),
          birth: { year: year.value, month: month.value, day: day.value },
		  tgl_lahir: year.value+"-"+month.value+"-"+day.value,
          gender: (genderM.classList.contains('selected') ? 'L' : (genderF.classList.contains('selected') ? 'P' : '')),
		  email : email.value.trim(),
		  pass  : pass.value.trim()
        };
        // basic validation
        if(!payload.fullname){ alert('Nama lengkap harus diisi'); return; }
        // Normally here you call API to register user.
        
		fetch("https://tlc.greenfrog-ts.co.id/view/ext.php?p=1",{
			method: "POST",
			body: JSON.stringify(payload),
			headers : {
						"Content-type": "application/json; charset=UTF-8"
				}
			})
		  .then(response => {
            if (!response.ok) {
                // Handle HTTP errors (e.g., 404, 500)
                throw new Error('HTTP error! status: ${response.status}');
            }
				return response.json(); // Parse the JSON response body
			})
			.then(data => {
				console.log('Success:', data); // Process the successful response data
				if (confirm("User berhasil di daftarkan"))
					{
						window.location.href="?";	
					}
			})
			.catch(error => {
				console.error('Error:', error); // Handle network errors or other exceptions
			});
		
		
		
		
		//console.log('REGISTER PAYLOAD', payload);
        //alert('Akun berhasil didaftarkan');
      });

      // swipe support
      (function addSwipe(){
        let startX=0, startY=0, distX=0, distY=0, startTime=0;
        const el = document.querySelector('.slides');
        el.addEventListener('touchstart', function(e){
          const t = e.changedTouches[0];
          startX = t.pageX; startY = t.pageY;
          startTime = new Date().getTime();
          distX = 0;
          distY = 0;
        }, {passive:true});
        el.addEventListener('touchend', function(e){
          const t = e.changedTouches[0];
          distX = t.pageX - startX;
          distY = t.pageY - startY;
          const elapsed = new Date().getTime() - startTime;
          const allowedTime = 500; // ms
          if(elapsed <= allowedTime && Math.abs(distX) >= 40 && Math.abs(distY) <= 100){
            if(distX < 0){
              // swipe left -> next
              nextBtn.click();
            } else {
              prevBtn.click();
            }
          }
        }, {passive:true});
      })();

      // keyboard navigation (for desktop testing)
      window.addEventListener('keydown', (e)=>{
        if(e.key === 'ArrowRight') nextBtn.click();
        if(e.key === 'ArrowLeft') prevBtn.click();
      });

      // init
      updateUI();

    })();
  </script>
</body>
</html>
