<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>TLC Bites — Asesmen</title>
<style>
  :root{
    --accent-green:#27ae60;
    --accent-yellow:#f2c94c;
    --muted:#e9f7ef;
    --card-bg:#ffffff;
    --text:#233;
    --danger:#d32f2f;
    --warning:#f39c12;
    --normal:#2e7d32;
  }
  html,body{height:100%;margin:0;font-family:Inter, system-ui, Arial, sans-serif;background:linear-gradient(180deg,#ffffff 60%, #fbfff5 100%);}
  /* minimal decorative circles */
  .decor{position:fixed;border-radius:50%;pointer-events:none;z-index:0;opacity:0.12}
  .decor.left{width:220px;height:220px;left:-80px;top:-80px;background:var(--accent-green)}
  .decor.right{width:180px;height:180px;right:-70px;bottom:-70px;background:var(--accent-yellow)}
  .wrap{max-width:420px;margin:0 auto;padding:18px;position:relative;z-index:1;min-height:100vh;display:flex;align-items:center;justify-content:center}
  .card{width:100%;background:var(--card-bg);border-radius:18px;box-shadow:0 8px 30px rgba(0,0,0,0.08);padding:18px;box-sizing:border-box;display:flex;flex-direction:column;align-items:center}
  .progressWrap{width:100%;margin-bottom:10px}
  .progress{height:8px;background:#eee;border-radius:6px;overflow:hidden}
  .progressBar{height:100%;background:var(--accent-green);width:0%;transition:width .25s ease}
  .stepLabel{font-size:12px;color:#666;margin-top:8px}
  .avatar{width:110px;height:110px;object-fit:contain;border-radius:12px;background:#fff;margin:8px 0}
  h1{font-size:18px;margin:6px 0;color:var(--text)}
  p.lead{font-size:14px;color:#555;margin:6px 0;text-align:center}
  .slider-row{width:100%;margin-top:10px}
  input[type=range]{-webkit-appearance:none;width:100%;height:6px;background:#eee;border-radius:6px;outline:none}
  input[type=range]::-webkit-slider-thumb{-webkit-appearance:none;width:18px;height:18px;border-radius:50%;background:var(--accent-green);border:2px solid #333}
  .ticksContainer{position:relative;height:24px;margin-top:6px;width:100%}
  .tick { position:absolute; bottom:12px; width:1px; background:#bbb; transform:translateX(-50%); }
  .tick.major{height:12px;background:#666}
  .tickLabel{position:absolute; bottom:0; transform:translateX(-50%); font-size:11px;color:#666}
  .valueDisplay{font-weight:700;font-size:20px;margin-top:8px;color:var(--text)}
  .resultLabel{margin-top:8px;font-weight:700}
  .resultLabel.normal{color:var(--normal)}
  .resultLabel.warning{color:var(--warning)}
  .resultLabel.danger{color:var(--danger)}
  .controls{width:100%;margin-top:18px;display:flex;gap:10px}
  .btn{flex:1;padding:12px;border-radius:10px;border:none;background:var(--accent-green);color:#fff;font-weight:700;font-size:15px;cursor:pointer}
  .btn:active{transform:translateY(1px)}
  .btn.secondary{background:#eee;color:#333}
  .summary{width:100%;text-align:left;margin-top:8px}
  .summaryItem{padding:10px;border-radius:10px;background:#fbfbfb;margin-bottom:8px;display:flex;justify-content:space-between;align-items:center}
  .summaryItem .status{font-weight:700}
  .finalAvatar{width:140px;height:140px;object-fit:contain;border-radius:12px;margin:6px auto;display:block}
  .logo-small{
      width:88px;
      height:auto;
      margin:6px auto 0;
      display:block;
    }
    .avatar-wrap{
      display:flex;
      align-items:center;
      justify-content:center;
    }
  
  /* responsive tweaks */
  @media (max-width:420px){
    .card{padding:16px;border-radius:14px}
    .avatar{width:100px;height:100px}
    .finalAvatar{width:120px;height:120px}
  }
</style>
</head>
<body>
  <div class="decor left"></div>
  <div class="decor right"></div>

  <div class="wrap">
    <div class="card" id="card">

      <!-- Progress -->
      <div class="progressWrap">
        <div class="progress"><div id="progressBar" class="progressBar"></div></div>
        <div class="stepLabel" id="stepLabel">1 / 9</div>
      </div>

      <!-- PAGES -->
      <!-- PAGE 1: Welcome -->
      <div id="page-1" class="page">
        <div class="avatar-wrap">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-1" alt="avatar" >
		</div>
        <img class="logo-small" src="../images/Up-Full-Black-trans-small.png" alt="TLC Bites Logo">
        <h1>Halo Kawan 👋</h1>
        <p class="lead">Mari kita mulai dengan beberapa pertanyaan agar kami lebih tahu tentangmu untuk membantu merencanakan program penurunan kolesterolmu.</p>
        <div style="width:100%;margin-top:12px">
          <button class="btn secondary" onclick="kembali()">Kembali</button>
          <button class="btn" onclick="goTo(2)">Mulai ➡</button>
        </div>
      </div>

      <!-- PAGE 2: Cholesterol -->
      <div id="page-2" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-2" alt="avatar">
        <h1>Kolesterol Total</h1>
        <p class="lead">Masukkan nilai kolesterol total (mg/dL)</p>
        <div class="slider-row">
          <input id="chol" type="range" min="0" max="300" step="1" value="150" />
          <div class="ticksContainer" id="ticks-chol"></div>
          <div class="valueDisplay"><span id="cholVal">150</span> mg/dL</div>
          <div id="cholRes" class="resultLabel normal"></div>
        </div>
        <div class="controls">
          <button class="btn secondary" onclick="goTo(1)">Kembali</button>
          <button class="btn" onclick="goTo(3)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 3: LDL -->
      <div id="page-3" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-3" alt="avatar">
        <h1>LDL</h1>
        <p class="lead">Masukkan nilai LDL (mg/dL)</p>
        <div class="slider-row">
          <input id="ldl" type="range" min="0" max="250" step="1" value="100" />
          <div class="ticksContainer" id="ticks-ldl"></div>
          <div class="valueDisplay"><span id="ldlVal">100</span> mg/dL</div>
          <div id="ldlRes" class="resultLabel normal"></div>
        </div>
        <div class="controls">
          <button class="btn secondary" onclick="goTo(2)">Kembali</button>
          <button class="btn" onclick="goTo(4)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 4: HDL -->
      <div id="page-4" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-4" alt="avatar">
        <h1>HDL</h1>
        <p class="lead">Masukkan nilai HDL (mg/dL)</p>
        <div class="slider-row">
          <input id="hdl" type="range" min="0" max="100" step="1" value="60" />
          <div class="ticksContainer" id="ticks-hdl"></div>
          <div class="valueDisplay"><span id="hdlVal">60</span> mg/dL</div>
          <div id="hdlRes" class="resultLabel normal"></div>
        </div>
        <div class="controls">
          <button class="btn secondary" onclick="goTo(3)">Kembali</button>
          <button class="btn" onclick="goTo(5)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 5: Triglyceride -->
      <div id="page-5" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-5" alt="avatar">
        <h1>Trigliserida</h1>
        <p class="lead">Masukkan nilai trigliserida (mg/dL)</p>
        <div class="slider-row">
          <input id="tri" type="range" min="0" max="300" step="1" value="120" />
          <div class="ticksContainer" id="ticks-tri"></div>
          <div class="valueDisplay"><span id="triVal">120</span> mg/dL</div>
          <div id="triRes" class="resultLabel normal"></div>
        </div>
        <div class="controls">
          <button class="btn secondary" onclick="goTo(4)">Kembali</button>
          <button class="btn" onclick="goTo(6)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 6: BMI -->
      <div id="page-6" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-6" alt="avatar">
        <h1>Status Gizi (BMI)</h1>
        <p class="lead">Atur tinggi badan (cm) dan berat badan (kg)</p>

        <div class="slider-row" style="margin-top:6px">
          <div style="font-size:13px;color:#666">Tinggi badan</div>
          <input id="height" type="range" min="100" max="220" step="1" value="170" />
          <div class="ticksContainer" id="ticks-height"></div>
          <div class="valueDisplay"><span id="heightVal">170</span> cm</div>
        </div>

        <div class="slider-row">
          <div style="font-size:13px;color:#666">Berat badan</div>
          <input id="weight" type="range" min="30" max="150" step="1" value="60" />
          <div class="ticksContainer" id="ticks-weight"></div>
          <div class="valueDisplay"><span id="weightVal">60</span> kg</div>
        </div>

        <div class="resultLabel" id="bmiRes" style="margin-top:10px"></div>

        <div class="controls">
          <button class="btn secondary" onclick="goTo(5)">Kembali</button>
          <button class="btn" onclick="goTo(7)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 7: Body Fat % -->
      <div id="page-7" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-7" alt="avatar">
        <h1>Persen Lemak Tubuh</h1>
        <p class="lead">Pilih jenis kelamin lalu masukkan persen lemak tubuh</p>
        <div style="display:flex;gap:8px;margin-top:8px">
          <button id="sexFemale" class="btn secondary" onclick="setSex('female')">Perempuan</button>
          <button id="sexMale" class="btn secondary" onclick="setSex('male')">Laki-laki</button>
        </div>

        <div class="slider-row" style="margin-top:12px">
          <input id="fat" type="range" min="0" max="50" step="1" value="22" />
          <div class="ticksContainer" id="ticks-fat"></div>
          <div class="valueDisplay"><span id="fatVal">22</span> %</div>
          <div id="fatRes" class="resultLabel normal"></div>
        </div>

        <div class="controls">
          <button class="btn secondary" onclick="goTo(6)">Kembali</button>
          <button class="btn" onclick="goTo(8)">Lanjut ➡</button>
        </div>
      </div>

      <!-- PAGE 8: Visceral Fat -->
      <div id="page-8" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="avatar" id="avatar-8" alt="avatar">
        <h1>Visceral Fat</h1>
        <p class="lead">Masukkan angka visceral fat</p>
        <div class="slider-row">
          <input id="vf" type="range" min="0" max="30" step="1" value="8" />
          <div class="ticksContainer" id="ticks-vf"></div>
          <div class="valueDisplay"><span id="vfVal">8</span></div>
          <div id="vfRes" class="resultLabel normal"></div>
        </div>
        <div class="controls">
          <button class="btn secondary" onclick="goTo(7)">Kembali</button>
          <button class="btn" onclick="complete()">Lanjut</button>
        </div>
      </div>

      <!-- FINAL: Summary -->
      <div id="page-final" class="page" style="display:none">
        <img src="../images/cat-normal.gif" class="finalAvatar" id="finalAvatar" alt="final avatar">
        <h1>Hasil Asesmen</h1>
        <p class="lead" id="finalSummaryLead">Ringkasan kondisi kamu</p>

        <div class="summary" id="summaryList"></div>

        <div style="width:100%;margin-top:12px">
          <button class="btn secondary" onclick="restart()">Ulangi</button>
          <button class="btn" onclick="konsumsi()">Lanjut Konsumsi</button>
        </div>
      </div>

    </div>
  </div>

<script>
/* ---------- Utility: generate ruler ticks ---------- */
function generateRuler(containerId, min, max, minorStep, majorStep){
  const cont = document.getElementById(containerId);
  cont.innerHTML = ''; // clear
  const range = max - min;
  // safety: avoid extreme number of ticks
  const approxTicks = Math.floor(range/minorStep);
  if(approxTicks > 200){
    minorStep = Math.ceil(range/200);
  }
  for(let v=min; v<=max; v+=minorStep){
    const p = ((v - min)/range)*100;
    const tick = document.createElement('div');
    tick.className = 'tick' + (v % majorStep === 0 ? ' major' : '');
    tick.style.left = p + '%';
    tick.title = (v%majorStep===0)?v:'';
    cont.appendChild(tick);
    if(v % majorStep === 0){
      const lbl = document.createElement('div');
      lbl.className = 'tickLabel';
      lbl.style.left = p + '%';
      lbl.innerText = v;
      cont.appendChild(lbl);
    }
  }
}

/* ---------- Pages control & progress ---------- */
let pageIndex = 1; // 1..8, final will be 9
const totalPages = 8;

function showPage(idx){
  for(let i=1;i<=8;i++){
    document.getElementById('page-'+i).style.display = (i===idx?'block':'none');
  }
  // hide welcome if idx>8 show others
  document.getElementById('page-1').style.display = (idx===1?'block':'none');
  document.getElementById('page-final').style.display = 'none';
  pageIndex = idx;
  updateProgress();
}

function goTo(idx){
  if(idx<1) idx=1;
  if(idx>8) idx=8;
  showPage(idx);
}

function updateProgress(){
  const pBar = document.getElementById('progressBar');
  const stepLabel = document.getElementById('stepLabel');
  // show as (current page of 9 incl welcome and final) - but we used 1..8 pages with welcome as 1
  const progressPercent = ((pageIndex)/ (totalPages+1)) * 100; // +1 to account for welcome
  pBar.style.width = progressPercent + '%';
  stepLabel.innerText = `${pageIndex} / ${totalPages+1}`;
}

/* ---------- Avatar filenames (replace with your gifs) ---------- */
const AVATARS = {
  normal: '../images/cat-normal.gif',
  kurus: '../images/cat-kurus.gif',
  warning: '../images/cat-warning.gif',
  gemuk: '../images/cat-gemuk.gif'
};

/* ---------- Rules per metric ---------- */
function cholRule(v){
  // per user: Normal 100–199, Elevated 200–239, Dangerous >240
  v = Number(v);
  if(v < 100) return {text:'Di bawah 100 (Low)', cls:'warning', cat:AVATARS.kurus};
  if(v >=100 && v <=199) return {text:'Normal (100–199)', cls:'normal', cat:AVATARS.normal};
  if(v >=200 && v <=239) return {text:'Elevated (200–239)', cls:'warning', cat:AVATARS.warning};
  return {text:'Dangerous (≥240)', cls:'danger', cat:AVATARS.gemuk};
}
function ldlRule(v){
  v = Number(v);
  if(v < 130) return {text:'Normal (<130)', cls:'normal', cat:AVATARS.normal};
  if(v >=130 && v <=159) return {text:'Waspada (130–159)', cls:'warning', cat:AVATARS.warning};
  return {text:'Berbahaya (≥160)', cls:'danger', cat:AVATARS.gemuk};
}
function hdlRule(v){
  v = Number(v);
  if(v >= 60) return {text:'Normal (≥60)', cls:'normal', cat:AVATARS.normal};
  if(v >= 40) return {text:'Waspada (40–59)', cls:'warning', cat:AVATARS.warning};
  return {text:'Berbahaya (<40)', cls:'danger', cat:AVATARS.gemuk};
}
function triRule(v){
  v = Number(v);
  if(v < 150) return {text:'Baik (<150)', cls:'normal', cat:AVATARS.normal};
  if(v >=150 && v <=199) return {text:'Waspada (150–199)', cls:'warning', cat:AVATARS.warning};
  return {text:'Berbahaya (≥200)', cls:'danger', cat:AVATARS.gemuk};
}
function bmiRule(bmi){
  const b = Number(bmi);
  if(b < 18.5) return {text:'Underweight (<18.5)', cls:'warning', cat:AVATARS.kurus};
  if(b >=18.5 && b <=24.9) return {text:'Normal (18.5–24.9)', cls:'normal', cat:AVATARS.normal};
  if(b >=25 && b <=29.9) return {text:'Overweight (25–29.9)', cls:'warning', cat:AVATARS.warning};
  return {text:'Obesitas (≥30)', cls:'danger', cat:AVATARS.gemuk};
}
function fatRule(v, sex){
  v = Number(v);
  if(sex==='male'){
    if(v < 10) return {text:'Underfat (<10%)', cls:'warning', cat:AVATARS.kurus};
    if(v <=20) return {text:'Healthy (10–20%)', cls:'normal', cat:AVATARS.normal};
    if(v <=25) return {text:'Overfat (21–25%)', cls:'warning', cat:AVATARS.warning};
    return {text:'Obese (>25%)', cls:'danger', cat:AVATARS.gemuk};
  } else {
    if(v < 20) return {text:'Underfat (<20%)', cls:'warning', cat:AVATARS.kurus};
    if(v <=30) return {text:'Healthy (20–30%)', cls:'normal', cat:AVATARS.normal};
    if(v <=35) return {text:'Overfat (31–35%)', cls:'warning', cat:AVATARS.warning};
    return {text:'Obese (>35%)', cls:'danger', cat:AVATARS.gemuk};
  }
}
function vfRule(v){
  v = Number(v);
  if(v >=1 && v <=10) return {text:'Normal (1–10)', cls:'normal', cat:AVATARS.normal};
  if(v >=11 && v <=15) return {text:'Berisiko (11–15)', cls:'warning', cat:AVATARS.warning};
  return {text:'Risiko Tinggi (>15)', cls:'danger', cat:AVATARS.gemuk};
}

/* ---------- Init rulers for each slider ---------- */
window.addEventListener('load', ()=>{
  // ruler settings: containerId, min, max, minorStep, majorStep
  generateRuler('ticks-chol', 0, 300, 10, 50);
  generateRuler('ticks-ldl', 0, 250, 10, 50);
  generateRuler('ticks-hdl', 0, 100, 5, 20);
  generateRuler('ticks-tri', 0, 300, 10, 50);
  generateRuler('ticks-height', 100, 220, 5, 10);
  generateRuler('ticks-weight', 30, 150, 5, 10);
  generateRuler('ticks-fat', 0, 50, 1, 10);
  generateRuler('ticks-vf', 0, 30, 1, 5);

  // wire sliders and initial updates
  setupSlider('chol','cholVal','cholRes','avatar-2',cholRule);
  setupSlider('ldl','ldlVal','ldlRes','avatar-3',ldlRule);
  setupSlider('hdl','hdlVal','hdlRes','avatar-4',hdlRule);
  setupSlider('tri','triVal','triRes','avatar-5',triRule);
  setupSlider('height','heightVal',null,'avatar-6',null); // BMI computed separately
  setupSlider('weight','weightVal',null,'avatar-6',null);
  setupSlider('fat','fatVal','fatRes','avatar-7',(v)=>fatRule(v, selectedSex));
  setupSlider('vf','vfVal','vfRes','avatar-8',vfRule);

  // initial sex selection default female (can be changed)
  setSex('female');

  // compute initial BMI display
  computeBMI();
  updateProgress();
});

/* ---------- sex toggle for bodyfat ---------- */
let selectedSex = 'female';
function setSex(s){
  selectedSex = s;
  document.getElementById('sexFemale').classList.toggle('btn-selected', s==='female');
  document.getElementById('sexMale').classList.toggle('btn-selected', s==='male');
  // update fat result
  const f = document.getElementById('fat').value;
  const res = fatRule(f, selectedSex);
  applyResult('fatRes', 'avatar-7', res);
}

/* ---------- slider wiring ---------- */
function setupSlider(sliderId, valId, resId, avatarId, ruleFn){
  const s = document.getElementById(sliderId);
  const vSpan = valId ? document.getElementById(valId) : null;
  const resDiv = resId ? document.getElementById(resId) : null;
  const avatarImg = avatarId ? document.getElementById(avatarId) : null;

  const handler = ()=> {
    const val = s.value;
    if(vSpan) vSpan.textContent = val;
    if(ruleFn){
      const r = ruleFn(val);
      if(resDiv){
        resDiv.textContent = r.text;
        resDiv.className = 'resultLabel ' + (r.cls || 'normal');
      }
      if(avatarImg && r.cat){
        avatarImg.src = r.cat;
      }
    }
    if(sliderId==='height' || sliderId==='weight'){ computeBMI(); }
  };

  s.addEventListener('input', handler);
  handler(); // initial
}

/* ---------- apply result helper ---------- */
function applyResult(resId, avatarId, ruleResult){
  const resDiv = document.getElementById(resId);
  const avatarImg = document.getElementById(avatarId);
  if(resDiv){
    resDiv.textContent = ruleResult.text;
    resDiv.className = 'resultLabel ' + ruleResult.cls;
  }
  if(avatarImg && ruleResult.cat){
    avatarImg.src = ruleResult.cat;
  }
}

/* ---------- BMI compute ---------- */
function computeBMI(){
  const h = Number(document.getElementById('height').value); // cm
  const w = Number(document.getElementById('weight').value); // kg
  document.getElementById('heightVal').textContent = h;
  document.getElementById('weightVal').textContent = w;
  const bmi = (w / ((h/100)*(h/100)));
  const bmiRounded = Math.round(bmi*10)/10;
  const res = bmiRule(bmiRounded);
  document.getElementById('bmiRes').textContent = res.text + ' ('+bmiRounded+')';
  document.getElementById('bmiRes').className = 'resultLabel ' + res.cls;
  document.getElementById('avatar-6').src = res.cat;
  document.getElementById('bmiVal')?.innerText && (document.getElementById('bmiVal').innerText=bmiRounded);
  return {bmi:bmiRounded,rule:res};
}

/* ---------- when user completes ---------- */
function complete(){
  // run final updates
  const cholVal = document.getElementById('chol').value;
  const ldlVal = document.getElementById('ldl').value;
  const hdlVal = document.getElementById('hdl').value;
  const triVal = document.getElementById('tri').value;
  const heightVal = document.getElementById('height').value;
  const weightVal = document.getElementById('weight').value;
  const fatVal = document.getElementById('fat').value;
  const vfVal = document.getElementById('vf').value;

  const cholR = cholRule(cholVal);
  const ldlR = ldlRule(ldlVal);
  const hdlR = hdlRule(hdlVal);
  const triR = triRule(triVal);
  const {bmi:bmiValue,rule:bmiR} = computeBMI();
  const fatR = fatRule(fatVal, selectedSex);
  const vfR = vfRule(vfVal);

  // final avatar selection: prioritize danger > warning > normal
  const rules = [cholR, ldlR, hdlR, triR, bmiR, fatR, vfR];
  let overall='normal';
  for(const r of rules){
    if(r.cls==='danger'){ overall='danger'; break; }
    if(r.cls==='warning' && overall!=='danger'){ overall='warning'; }
  }
  const finalCat = (overall==='danger')?AVATARS.gemuk: (overall==='warning'?AVATARS.warning:AVATARS.normal);

  // build summary HTML
  const summaryList = document.getElementById('summaryList');
  summaryList.innerHTML = `
    <div class="summaryItem"><div><strong>Kolesterol</strong><div style="font-size:12px;color:#666">${cholVal} mg/dL</div></div><div class="status">${cholR.text}</div></div>
    <div class="summaryItem"><div><strong>LDL</strong><div style="font-size:12px;color:#666">${ldlVal} mg/dL</div></div><div class="status">${ldlR.text}</div></div>
    <div class="summaryItem"><div><strong>HDL</strong><div style="font-size:12px;color:#666">${hdlVal} mg/dL</div></div><div class="status">${hdlR.text}</div></div>
    <div class="summaryItem"><div><strong>Trigliserida</strong><div style="font-size:12px;color:#666">${triVal} mg/dL</div></div><div class="status">${triR.text}</div></div>
    <div class="summaryItem"><div><strong>BMI</strong><div style="font-size:12px;color:#666">${bmiValue}</div></div><div class="status">${bmiR.text}</div></div>
    <div class="summaryItem"><div><strong>% Lemak Tubuh</strong><div style="font-size:12px;color:#666">${fatVal}% (${selectedSex})</div></div><div class="status">${fatR.text}</div></div>
    <div class="summaryItem"><div><strong>Visceral Fat</strong><div style="font-size:12px;color:#666">${vfVal}</div></div><div class="status">${vfR.text}</div></div>
  `;
  document.getElementById('finalAvatar').src = finalCat;
  document.getElementById('finalSummaryLead').innerText = overall==='danger' ? 'Hati-hati — beberapa indikator berada di level berisiko.' : (overall==='warning' ? 'Beberapa indikator perlu perhatian.' : 'Semua indikator dalam rentang normal.');
  // hide pages and show final
  for(let i=1;i<=8;i++) document.getElementById('page-'+i).style.display='none';
  document.getElementById('page-final').style.display='block';
  // update progress full
  document.getElementById('progressBar').style.width = '100%';
  document.getElementById('stepLabel').innerText = 'Selesai';
}
/*----------ke Konsumsi -------- */
function konsumsi()
{
  const cholVal = document.getElementById('chol').value;
  const ldlVal = document.getElementById('ldl').value;
  const hdlVal = document.getElementById('hdl').value;
  const triVal = document.getElementById('tri').value;
  const heightVal = document.getElementById('height').value;
  const weightVal = document.getElementById('weight').value;
  const fatVal = document.getElementById('fat').value;
  const vfVal = document.getElementById('vf').value;
  const {bmi:bmiValue,rule:bmiR} = computeBMI();

  const payload = {
	  kolesterol : cholVal,
	  ldl : ldlVal,
	  hdl : hdlVal,
	  tri : triVal,
	  height : heightVal,
	  weight : weightVal,
	  fat 	: fatVal,
	  vf	 : vfVal,
	  
	  }

  //call api
  		fetch("https://tlc.greenfrog-ts.co.id/view/ext.php?p=2",{
			method: "POST",
			body: JSON.stringify(payload),
			headers : {
						"Content-type": "application/json; charset=UTF-8"
				}
			})
		  .then(response => {
            if (!response.ok) {
                // Handle HTTP errors (e.g., 404, 500)
                throw new Error('HTTP error! status: ${response.status}');
            }
				return response.json(); // Parse the JSON response body
			})
			.then(data => {
				console.log('Success:', data); // Process the successful response data
				window.location.href="?d=makan";
			})
			.catch(error => {
				console.error('Error:', error); // Handle network errors or other exceptions
			});
      



}
/* ---------- kembali ---------- */
function kembali()
{
	window.location.href="?";
}
/* ---------- restart ---------- */
function restart(){ location.reload(); }

/* ---------- small helper to ensure showPage initial ---------- */
function showInitial(){
  // show welcome page
  for(let i=1;i<=8;i++) document.getElementById('page-'+i).style.display = 'none';
  document.getElementById('page-final').style.display = 'none';
  document.getElementById('page-1').style.display = 'block';
  pageIndex=1; updateProgress();
}
showInitial();

</script>
</body>
</html>
